#!/usr/bin/env python
import commands
from distutils.core import setup
from distutils.extension import Extension

ext_modules = []

pkgs = 'gdk-2.0 gtk+-2.0 pygtk-2.0'
cflags = commands.getoutput('pkg-config --cflags %s' % pkgs)
libs = commands.getoutput('pkg-config --libs %s' % pkgs)
include_dirs = [part.strip() for part in cflags.split('-I') if part]
libraries = [part.strip() for part in libs.split('-l') if part]
ext_modules.append(Extension('launcher/_gtkhelper', ['launcher/_gtkhelper.c'],
                             include_dirs=include_dirs,
                             libraries=libraries))

setup(name="python-launcher",
      version="0.1.0",
      description="A daemon to speedup python applications",
      author="Johan Dahlin",
      author_email="johan@gnome.org",
      license="GNU LGPL 2.1 (see COPYING)",
      scripts=['python-launcher',
               'python-launcher-daemon'],
      packages=['launcher'],
      ext_modules=ext_modules,
      )
