#
# Copyright (C) 2007 Johan Dahlin
#
# All rights reserved
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
# USA.
#

import os

class ISupport:
    def daemon_init():
        pass

    def client_init(progname):
        pass

class GTKSupport(object):

    # implements(ISupport)

    def __init__(self):
        self._settings = None
        self._display = None

    def daemon_init(self):
        import gtk
        self._settings = gtk.settings_get_default()

    def client_init(self, progfilename):
        from gtk import gdk
        from launcher._gtkhelper import gtk_settings_set_for_screen

        progname = os.path.basename(progfilename)
        # g_set_prgname(progname)
        gdk.set_program_class(progname.upper())

        # Open a new display, i.e. a new X connection and make it the default.
        display = gdk.Display(gdk.get_display_arg_name() or '')
        dm = gdk.display_manager_get()
        dm.set_default_display(display)

        # Associate the old settings with the new display's default screen.
        gtk_settings_set_for_screen(gdk.screen_get_default(), self._settings)

        # We need to save a reference to the display or it will be
        # garbage collected.
        self._display = display

def get_supported_modules():
    return [GTKSupport()]
