#
# Copyright (C) 2007 Johan Dahlin
#
# All rights reserved
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
# USA.
#

import os
import socket

from launcher.common import DAEMON_SOCKET

class Client(object):
    def __init__(self):
        if not os.path.exists(DAEMON_SOCKET):
            raise SystemExit("ERROR: python-launcher-daemon is not running")

        self._sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        try:
            self._sock.connect(DAEMON_SOCKET)
        except socket.error:
            raise SystemExit("ERROR: python-launcher-daemon is not running")

    def run_process(self, args):
        print 'running process', args
        for arg in args:
            self._sock.send(arg + "\n")
