/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2005 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Created on 06.04.2006
 *  --- CVS Information ---
 *  $Id$
 */
package phex.gui.common;

import java.awt.*;
import java.awt.font.LineMetrics;

import javax.swing.Icon;

public class LabeledIcon implements Icon
{
    private Icon delegate;
    private String label;
    
    public LabeledIcon( Icon delegate, String label )
    {
        this.delegate = delegate;
        this.label = label;
    }
    
    public void setLabel( String label )
    {
        this.label = label;
    }

    /**
     * @see javax.swing.Icon#getIconHeight()
     */
    public int getIconHeight()
    {
        return delegate.getIconHeight();
    }

    /**
     * @see javax.swing.Icon#getIconWidth()
     */
    public int getIconWidth()
    {
        return delegate.getIconWidth();
    }

    /**
     * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
     */
    public void paintIcon(Component c, Graphics g, int x, int y)
    {
        delegate.paintIcon( c, g, x, y );
        if ( label != null )
        {
            Font originalFont = g.getFont();
            
            Font font = g.getFont();
            font = font.deriveFont( font.getSize2D() - 4 );
            g.setFont( font );
            
            FontMetrics metrics = g.getFontMetrics();
            LineMetrics lineMetrics = metrics.getLineMetrics(label, g);
            //g.setColor(Color.RED);
            g.drawString( label, 
                (int)(x + delegate.getIconWidth() / 2
                - metrics.stringWidth( label ) / 2 - 1), 
                (int)(y + delegate.getIconHeight() / 2 
                + lineMetrics.getHeight() / 2 - 1) );
            
            g.setFont( originalFont );
        }
    }
}