/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Created on 03.12.2005
 *  --- CVS Information ---
 *  $Id: ManagerController.java 3362 2006-03-30 22:27:26Z gregork $
 */
package phex.common;

import java.util.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import phex.utils.NLogger;
import phex.utils.NLoggerNames;

public class ManagerController
{
    static private final List MANAGER_LIST;
    static
    {
        List tmpList = new ArrayList();
        tmpList.add( phex.download.swarming.SwarmingManager.getInstance() );
        tmpList.add( phex.connection.NetworkManager.getInstance() );
        tmpList.add( phex.udp.UdpConnectionManager.getInstance() );
        tmpList.add( phex.upload.UploadManager.getInstance() );
        tmpList.add( phex.share.ShareManager.getInstance() );
        tmpList.add( phex.query.QueryManager.getInstance() );
        tmpList.add( phex.chat.ChatManager.getInstance() );
        tmpList.add( phex.host.HostManager.getInstance() );
        tmpList.add( phex.security.PhexSecurityManager.getInstance() );
        tmpList.add( phex.msg.MsgManager.getInstance() );
        tmpList.add( phex.statistic.StatisticsManager.getInstance() );
        tmpList.add( phex.common.bandwidth.BandwidthManager.getInstance() );
        tmpList.add( phex.gwebcache.GWebCacheManager.getInstance() );
        tmpList.add( phex.common.Ip2CountryManager.getInstance() );
        tmpList.add( phex.udp.hostcache.UdpHostCacheManager.getInstance() );
        MANAGER_LIST = Collections.unmodifiableList( tmpList );
    }
    
    public static void initializeManagers()
    {
        Iterator iterator = MANAGER_LIST.iterator();
        while ( iterator.hasNext() )
        {
            Manager manager = (Manager) iterator.next();
            long start = System.currentTimeMillis();
            NLogger.debug( NLoggerNames.GLOBAL,
                "Initializing " + manager.getClass().getName() );
            boolean succ = manager.initialize();
            if ( !succ )
            {
                NLogger.error( NLoggerNames.GLOBAL,
                    "Failed to initialize " + manager.getClass().getName() );
                throw new RuntimeException( "Failed to initialize " +
                    manager.getClass().getName() );
            }
            long end = System.currentTimeMillis();
            NLogger.debug( NLoggerNames.GLOBAL, 
                "Initialization time: " + (end-start) + " - " 
                + manager.getClass().getName());
        }
        
        postInitializeManagers();
    }

    /**
     * 
     */
    private static void postInitializeManagers()
    {
        Iterator iterator = MANAGER_LIST.iterator();
        while ( iterator.hasNext() )
        {
            Manager manager = (Manager) iterator.next();
            long start = System.currentTimeMillis();
            NLogger.debug( NLoggerNames.GLOBAL,
                "On post initialization " + manager.getClass().getName() );
            boolean succ = manager.onPostInitialization();
            if ( !succ )
            {
                NLogger.error( NLoggerNames.GLOBAL,
                    "Failed to initialize " + manager.getClass().getName() );
                throw new RuntimeException( "Failed to initialize " +
                    manager.getClass().getName() );
            }
            long end = System.currentTimeMillis();
            NLogger.debug( NLoggerNames.GLOBAL, 
                "Post-Initialization time: " + (end-start) + " - " 
                + manager.getClass().getName());
        }
    }
    
    /**
     * This method is called after the complete application including GUI completed
     * its startup process.
     */
    public static void startupCompletedNotify()
    {
        Iterator iterator = MANAGER_LIST.iterator();
        while ( iterator.hasNext() )
        {
            Manager manager = (Manager) iterator.next();
            long start = System.currentTimeMillis();
            NLogger.debug( NLoggerNames.GLOBAL,
                "StartupCompletedNotify " + manager.getClass().getName() );
            manager.startupCompletedNotify();
            long end = System.currentTimeMillis();
            NLogger.debug( NLoggerNames.GLOBAL, 
                "StartupCompletedNotify time: " + (end-start) + " - " 
                + manager.getClass().getName());
        }
    }    

    public static void shutdownManagers( )
    {
        Iterator iterator = MANAGER_LIST.iterator();
        while ( iterator.hasNext() )
        {
            try
            {
                Manager manager = (Manager) iterator.next();
                long start = System.currentTimeMillis();
                NLogger.debug( NLoggerNames.GLOBAL,
                    "Shutdown " + manager.getClass().getName() );
                manager.shutdown();
                long end = System.currentTimeMillis();
                NLogger.debug( NLoggerNames.GLOBAL, 
                    "Shutdown time: " + (end-start) + " - " 
                    + manager.getClass().getName());
            }
            catch ( Exception exp )
            {
                NLogger.error( NLoggerNames.GLOBAL, exp, exp  );
            }
        }
    }
}
