/*
 * Decompiled with CFR 0.152.
 */
package phex.test.performance;

import com.bitzi.util.Base32;
import com.bitzi.util.SHA1;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import junit.framework.TestCase;
import org.apache.commons.lang.SystemUtils;

public class TestSHA1
extends TestCase {
    public TestSHA1(String string) {
        super(string);
    }

    public void testSHA1() throws Exception {
        File file = SystemUtils.getJavaHome();
        File[] fileArray = file.listFiles();
        this.sha1TestFiles(fileArray);
    }

    public void sha1TestFiles(File[] fileArray) throws Exception {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                String string = this.calcSHA1(fileArray[i], (MessageDigest)new SHA1());
                String string2 = this.calcSHA1(fileArray[i], MessageDigest.getInstance("SHA"));
                System.out.println(string + " - " + string2);
                TestSHA1.assertTrue((boolean)string.equals(string2));
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            this.sha1TestFiles(fileArray[i].listFiles());
        }
    }

    public String calcSHA1(File file, MessageDigest messageDigest) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[65536];
        long l = System.currentTimeMillis();
        while ((n = fileInputStream.read(byArray)) != -1) {
            long l2 = System.currentTimeMillis();
            messageDigest.update(byArray, 0, n);
            long l3 = System.currentTimeMillis();
            Thread.sleep((l3 - l2) * 2L);
        }
        fileInputStream.close();
        byte[] byArray2 = messageDigest.digest();
        long l4 = System.currentTimeMillis();
        System.out.println("Digest: " + messageDigest.getClass() + " SHA1 time: " + (l4 - l) + " size: " + file.length());
        return Base32.encode((byte[])byArray2);
    }
}

