/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.msg.GUID;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.net.connection.Connection;
import phex.test.AccessUtils;
import phex.upload.UploadManager;
import phex.utils.GnutellaInputStream;
import phex.utils.GnutellaOutputStream;

public class TestMsgQueryResponse
extends TestCase {
    public TestMsgQueryResponse(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testCreateAndParse() throws Exception {
        MsgHeader msgHeader = new MsgHeader(new GUID(), -127, 7, 0, 0);
        QueryResponseRecord queryResponseRecord = new QueryResponseRecord(1, new URN("urn:sha1:LO4DP3SD3I3CZZP6PIKG3VCQHG4KTQD2"), 1, "file", -1L, null);
        QueryResponseRecord[] queryResponseRecordArray = new QueryResponseRecord[]{queryResponseRecord};
        QueryResponseMsg queryResponseMsg = new QueryResponseMsg(msgHeader, new GUID(), (DestAddress)new DefaultDestAddress("111.111.111.111", 1111), 0, queryResponseRecordArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GnutellaOutputStream gnutellaOutputStream = new GnutellaOutputStream((OutputStream)byteArrayOutputStream);
        queryResponseMsg.writeMessage(gnutellaOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        GnutellaInputStream gnutellaInputStream = new GnutellaInputStream((InputStream)new ByteArrayInputStream(byArray));
        Connection connection = new Connection(null, null);
        AccessUtils.setFieldValue(connection, "inputStream", gnutellaInputStream);
        QueryResponseMsg queryResponseMsg2 = (QueryResponseMsg)MessageProcessor.parseMessage((Connection)connection);
        MsgHeader msgHeader2 = queryResponseMsg2.getHeader();
        TestMsgQueryResponse.assertEquals((int)msgHeader.getDataLength(), (int)msgHeader2.getDataLength());
        TestMsgQueryResponse.assertEquals((byte)msgHeader.getHopsTaken(), (byte)msgHeader2.getHopsTaken());
        TestMsgQueryResponse.assertEquals((String)msgHeader.getMsgID().toHexString(), (String)msgHeader2.getMsgID().toHexString());
        TestMsgQueryResponse.assertEquals((byte)msgHeader.getPayload(), (byte)msgHeader2.getPayload());
        TestMsgQueryResponse.assertEquals((byte)msgHeader.getTTL(), (byte)msgHeader2.getTTL());
        TestMsgQueryResponse.assertEquals((Object)queryResponseMsg.getDestAddress(), (Object)queryResponseMsg2.getDestAddress());
        TestMsgQueryResponse.assertEquals((short)queryResponseMsg.getRecordCount(), (short)queryResponseMsg2.getRecordCount());
        TestMsgQueryResponse.assertEquals((Object)queryResponseMsg.getRemoteClientID(), (Object)queryResponseMsg2.getRemoteClientID());
        TestMsgQueryResponse.assertEquals((long)queryResponseMsg.getRemoteHostSpeed(), (long)queryResponseMsg2.getRemoteHostSpeed());
        TestMsgQueryResponse.assertEquals((short)queryResponseMsg.getUploadSpeedFlag(), (short)queryResponseMsg2.getUploadSpeedFlag());
        TestMsgQueryResponse.assertEquals((short)queryResponseMsg.getPushNeededFlag(), (short)queryResponseMsg2.getPushNeededFlag());
        TestMsgQueryResponse.assertEquals((boolean)ServiceManager.sCfg.mShareBrowseDir, (boolean)queryResponseMsg2.isBrowseHostSupported());
        TestMsgQueryResponse.assertEquals((short)-1, (short)queryResponseMsg2.getHasUploadedFlag());
        TestMsgQueryResponse.assertEquals((String)"PHEX", (String)queryResponseMsg2.getVendorCode());
        TestMsgQueryResponse.assertEquals((boolean)true, (boolean)queryResponseMsg2.isChatSupported());
        TestMsgQueryResponse.assertEquals((boolean)ServiceManager.sCfg.isChatEnabled, (boolean)queryResponseMsg2.isChatSupported());
        TestMsgQueryResponse.assertEquals((short)(UploadManager.getInstance().isHostBusy() ? (short)1 : 0), (short)queryResponseMsg2.getServerBusyFlag());
    }
}

