/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import junit.framework.TestCase;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;

public class TestIPAccessRule
extends TestCase {
    byte[][] testSingleAddresses;

    protected void setUp() throws Exception {
        this.testSingleAddresses = new byte[][]{{11, 2, 3, 4}, {22, 3, 4, 5}, {33, 5, 6, 7}, {44, 8, 9, 1}, {66, 8, 9, 1}, {77, 8, 9, 1}, {88, 8, 9, 1}, {99, 8, 9, 1}};
    }

    public void testSingleAddress() throws Exception {
        boolean bl;
        IPAccessRule iPAccessRule;
        int n;
        int n2;
        for (n2 = 0; n2 < this.testSingleAddresses.length; ++n2) {
            for (n = 0; n < this.testSingleAddresses.length; ++n) {
                iPAccessRule = new IPAccessRule("test", true, 1, this.testSingleAddresses[n], null);
                bl = iPAccessRule.isHostIPAllowed(this.testSingleAddresses[n2]);
                if (n2 != n) {
                    TestIPAccessRule.assertTrue((boolean)bl);
                    continue;
                }
                TestIPAccessRule.assertFalse((boolean)bl);
            }
        }
        for (n2 = 0; n2 < this.testSingleAddresses.length; ++n2) {
            for (n = 0; n < this.testSingleAddresses.length; ++n) {
                iPAccessRule = new IPAccessRule("test", false, 1, this.testSingleAddresses[n], null);
                bl = iPAccessRule.isHostIPAllowed(this.testSingleAddresses[n2]);
                if (n2 == n) {
                    TestIPAccessRule.assertTrue((boolean)bl);
                    continue;
                }
                TestIPAccessRule.assertFalse((boolean)bl);
            }
        }
    }

    public void testAddressMask() throws Exception {
        IPAccessRule iPAccessRule = new IPAccessRule("test", true, 2, new byte[]{11, 1, 1, 0}, new byte[]{-1, -1, -1, 0});
        boolean bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 2});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 2, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 2, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{12, 1, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        iPAccessRule = new IPAccessRule("test", true, 2, new byte[]{11, 1, 1, 0}, new byte[]{-1, -1, 0, 0});
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 2});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 2, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 2, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{12, 1, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        iPAccessRule = new IPAccessRule("test", true, 2, new byte[]{11, 1, 1, 0}, new byte[]{-1, 0, 0, 0});
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 2});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 2, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 2, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{12, 1, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        iPAccessRule = new IPAccessRule("test", true, 2, new byte[]{-47, -52, -128, 0}, new byte[]{-1, -1, -1, -64});
        bl = iPAccessRule.isHostIPAllowed(new byte[]{-47, -52, -128, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{-47, -52, -128, 60});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{-47, -52, -128, 64});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{-47, -52, -128, -128});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{-47, -52, -128, -6});
        TestIPAccessRule.assertTrue((boolean)bl);
    }

    public void testAddressRange() throws Exception {
        IPAccessRule iPAccessRule = new IPAccessRule("test", true, 3, new byte[]{11, 1, 1, 2}, new byte[]{11, 1, 1, 3});
        boolean bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 2});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 3});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 2, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 2, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{12, 1, 1, 1});
        TestIPAccessRule.assertTrue((boolean)bl);
        iPAccessRule = new IPAccessRule("test", false, 3, new byte[]{11, 1, 1, 2}, new byte[]{11, 1, 1, 3});
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 2});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, 3});
        TestIPAccessRule.assertTrue((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 2, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 2, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{12, 1, 1, 1});
        TestIPAccessRule.assertFalse((boolean)bl);
        bl = iPAccessRule.isHostIPAllowed(new byte[]{11, 1, 1, -2});
        TestIPAccessRule.assertFalse((boolean)bl);
    }

    public void testHostileHostList() throws Exception {
        PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
        long l = System.currentTimeMillis();
        byte by = phexSecurityManager.controlHostAddressAccess((DestAddress)new DefaultDestAddress("12.12.12.12", 80));
        TestIPAccessRule.assertEquals((byte)by, (byte)1);
        by = phexSecurityManager.controlHostAddressAccess((DestAddress)new DefaultDestAddress("32.1.2.3", 80));
        TestIPAccessRule.assertEquals((byte)by, (byte)3);
        by = phexSecurityManager.controlHostAddressAccess((DestAddress)new DefaultDestAddress("216.34.123.56", 80));
        TestIPAccessRule.assertEquals((byte)by, (byte)3);
        long l2 = System.currentTimeMillis();
        System.out.println("Time: " + (l2 - l));
    }
}

