/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterInputStream;
import junit.framework.TestCase;
import phex.utils.IOUtil;

public class TestIOUtil
extends TestCase {
    private byte[] randomData;

    public TestIOUtil(String string) {
        super(string);
    }

    protected void setUp() {
        int n;
        this.randomData = new byte[100000];
        Random random = new Random();
        random.nextBytes(this.randomData);
        for (n = 300; n < 500; ++n) {
            this.randomData[n] = 0;
        }
        for (n = 3000; n < 5000; ++n) {
            this.randomData[n] = 0;
        }
    }

    protected void tearDown() {
    }

    public void testDeflate() throws IOException {
        byte[] byArray = IOUtil.deflate((byte[])this.randomData);
        TestIOUtil.assertTrue((byArray.length < this.randomData.length ? 1 : 0) != 0);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n = 0;
        do {
            if ((n = inflaterInputStream.read(byArray2)) <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n);
        } while (n > 0);
        TestIOUtil.assertTrue((boolean)Arrays.equals(byteArrayOutputStream.toByteArray(), this.randomData));
    }

    public void testSimpleInflate() throws DataFormatException {
        byte[] byArray = IOUtil.deflate((byte[])this.randomData);
        byte[] byArray2 = IOUtil.inflate((byte[])byArray);
        TestIOUtil.assertTrue((boolean)Arrays.equals(byArray2, this.randomData));
    }

    public void testCobs() throws IOException {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 1, 0, 0, 3, 0, 4, 3, 4, 5, 3, 6, 0, 0, 0, 0, 0, 0, 0, 3, 4, 3, 5, 4, 5, 6, 0, 0, 2, 3, 4, 2, 3};
        byte[] byArray2 = IOUtil.cobsEncode((byte[])byArray);
        byte[] byArray3 = IOUtil.cobsDecode((byte[])byArray2);
        TestIOUtil.assertTrue((boolean)Arrays.equals(byArray, byArray3));
        byArray = new byte[]{69, 0, 0, 44, 76, 121, 0, 0, 64, 6, 79, 55};
        byArray2 = IOUtil.cobsEncode((byte[])byArray);
        byte[] byArray4 = new byte[]{2, 69, 1, 4, 44, 76, 121, 1, 5, 64, 6, 79, 55};
        TestIOUtil.assertTrue((boolean)Arrays.equals(byArray2, byArray4));
        byArray3 = IOUtil.cobsDecode((byte[])byArray4);
        TestIOUtil.assertTrue((boolean)Arrays.equals(byArray, byArray3));
    }
}

