/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.rules;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.rules.condition.FileSizeCondition;
import phex.utils.NLogger;
import phex.xml.sax.rules.DFileSizeCondition;

public class FileSizeConditionHandler
extends DefaultHandler {
    public static final String ELEMENT_NAME = "filesize-condition";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DFileSizeCondition condition;
    private DefaultHandler parent;

    public FileSizeConditionHandler(DFileSizeCondition condition, Attributes attributes, DefaultHandler parent, SAXParser parser) {
        this.condition = condition;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equals("range")) {
            long min = -1L;
            long max = -1L;
            String minStr = attributes.getValue("min");
            String maxStr = attributes.getValue("min");
            try {
                min = Long.parseLong(minStr);
            }
            catch (NumberFormatException exp) {
                NLogger.error(FileSizeConditionHandler.class, (Object)exp, (Throwable)exp);
            }
            try {
                max = Long.parseLong(maxStr);
            }
            catch (NumberFormatException exp) {
                NLogger.error(FileSizeConditionHandler.class, (Object)exp, (Throwable)exp);
            }
            if (min >= 0L || max >= 0L) {
                FileSizeCondition.Range range = new FileSizeCondition.Range(min, max);
                this.condition.getRanges().add(range);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(ELEMENT_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

