/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.NLogger;
import phex.xml.sax.DPhex;
import phex.xml.sax.parser.PhexSAXHandler;

public class PhexXmlSaxParser {
    public static DPhex parsePhexXml(InputStream inStream) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = spf.newSAXParser();
            DPhex dPhex = new DPhex();
            saxParser.parse(new InputSource(inStream), (DefaultHandler)new PhexSAXHandler(dPhex, saxParser));
            return dPhex;
        }
        catch (ParserConfigurationException exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
            throw new IOException("Parsing Phex XML failed.");
        }
        catch (SAXException exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
            throw new IOException("Parsing Phex XML failed.");
        }
    }

    public static void main(String[] args) throws IOException, JAXBException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            FileInputStream inStream = new FileInputStream("C:\\temp\\resp.xml");
            PhexXmlSaxParser.parsePhexXml(inStream);
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
        start = System.currentTimeMillis();
        JAXBContext jc = JAXBContext.newInstance("phex.xml");
        for (int i = 0; i < 1000; ++i) {
            FileInputStream inStream = new FileInputStream("C:\\temp\\resp.xml");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.unmarshal(inStream);
        }
        end = System.currentTimeMillis();
        System.out.println(end - start);
    }
}

