/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import phex.utils.WordTable;

public class WordTableByTree
extends WordTable {
    private Node root = new Node();
    private List gopher = new ArrayList();

    public void store(String keyString, Object item) {
        this.fillList(this.gopher, keyString);
        if (this.gopher.isEmpty()) {
            throw new IllegalArgumentException("Key string contains no usefull sub strings");
        }
        Node current = this.root;
        Iterator i = this.gopher.iterator();
        while (i.hasNext()) {
            current = current.getChild(i.next(), true);
        }
        current.addItem(item);
    }

    public void fetch(String keyString, WordTable.HitListener hitListener) {
        this.fillList(this.gopher, keyString);
        for (int i = 0; i < this.gopher.size(); ++i) {
            Node current = this.root;
            for (int j = i; j < this.gopher.size() && (current = current.getChild(this.gopher.get(j), false)) != null; ++j) {
                Set hits = current.getItems();
                if (hits == null) continue;
                Iterator hi = hits.iterator();
                while (hi.hasNext()) {
                    hitListener.processHit(hi.next());
                }
            }
        }
    }

    private void dumpTree(String leader, Node node) {
        if (node.children == null) {
            System.out.println(leader + node);
        }
        if (node.items != null) {
            System.out.println(leader + node.items);
        }
        if (node.children != null) {
            Iterator i = node.children.keySet().iterator();
            while (i.hasNext()) {
                Object it = i.next();
                System.out.println(leader + "-> " + it);
                this.dumpTree(leader + "  ", (Node)node.children.get(it));
            }
        }
    }

    private static class Node {
        private Map children;
        private Set items;

        private Node() {
        }

        public Node getChild(Object o, boolean create) {
            Node child = null;
            if (this.children == null) {
                if (create) {
                    this.children = new HashMap();
                    child = new Node();
                    this.children.put(o, child);
                }
            } else {
                child = (Node)this.children.get(o);
                if (child == null) {
                    child = new Node();
                    this.children.put(o, child);
                }
            }
            return child;
        }

        public Set getItems() {
            return this.items;
        }

        public void addItem(Object item) {
            if (this.items == null) {
                this.items = new WordTable.DiffSet();
            }
            this.items.add(item);
        }
    }
}

