/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimerTask;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.connection.NetworkManager;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;

public class SubscriptionDownloader
extends TimerTask {
    public SubscriptionDownloader() {
        Environment.getInstance().scheduleTimerTask(this, 0L, 172800000L);
    }

    public void run() {
        ArrayList subscriptionMagnets = ServiceManager.sCfg.subscriptionMagnets;
        if (subscriptionMagnets == null && Cfg.default_subscriptionMagnets != null) {
            subscriptionMagnets.add(Cfg.default_subscriptionMagnets);
        }
        Iterator iterator = subscriptionMagnets.iterator();
        while (iterator.hasNext()) {
            String uriStr = (String)iterator.next();
            NetworkManager.getInstance().fireIncomingUriDownload(uriStr);
        }
    }

    private void createDownload(String uriStr) throws URIException {
        if (uriStr.length() == 0) {
            return;
        }
        URI uri = new URI(uriStr, true);
        MagnetData magnetData = MagnetData.parseFromURI(uri);
        URN urn = MagnetData.lookupSHA1URN(magnetData);
        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
        if (!swarmingMgr.isURNDownloaded(urn)) {
            swarmingMgr.addFileToDownload(uri);
        }
    }
}

