/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import phex.common.Environment;
import phex.utils.IOUtil;

public class NLogger {
    public static final short LOG_LEVEL_DEBUG = 1;
    public static final short LOG_LEVEL_INFO = 2;
    public static final short LOG_LEVEL_WARN = 3;
    public static final short LOG_LEVEL_ERROR = 4;
    private static LogFactory factory;

    public static Log getLogInstance(String name) {
        try {
            return factory.getInstance(name);
        }
        catch (LogConfigurationException exp) {
            Properties sysProps = System.getProperties();
            sysProps.put("org.apache.commons.logging.Log", "phex.utils.PhexLogger");
            LogFactory.releaseAll();
            factory = LogFactory.getFactory();
            return factory.getInstance(name);
        }
    }

    public static Log getLogInstance(Class clazz) {
        try {
            return factory.getInstance(clazz);
        }
        catch (LogConfigurationException exp) {
            Properties sysProps = System.getProperties();
            sysProps.put("org.apache.commons.logging.Log", "phex.utils.PhexLogger");
            LogFactory.releaseAll();
            factory = LogFactory.getFactory();
            return factory.getInstance(clazz);
        }
    }

    public static boolean isDebugEnabled(String name) {
        return NLogger.getLogInstance(name).isDebugEnabled();
    }

    public static boolean isDebugEnabled(Class clazz) {
        return NLogger.getLogInstance(clazz).isDebugEnabled();
    }

    public static boolean isInfoEnabled(String name) {
        return NLogger.getLogInstance(name).isInfoEnabled();
    }

    public static boolean isWarnEnabled(String name) {
        return NLogger.getLogInstance(name).isWarnEnabled();
    }

    public static boolean isWarnEnabled(Class clazz) {
        return NLogger.getLogInstance(clazz).isWarnEnabled();
    }

    public static boolean isErrorEnabled(String name) {
        return NLogger.getLogInstance(name).isErrorEnabled();
    }

    public static boolean isEnabled(short logLevel, String name) {
        switch (logLevel) {
            case 1: {
                return NLogger.isDebugEnabled(name);
            }
            case 2: {
                return NLogger.isInfoEnabled(name);
            }
            case 3: {
                return NLogger.isWarnEnabled(name);
            }
            case 4: {
                return NLogger.isErrorEnabled(name);
            }
        }
        throw new IllegalArgumentException("Unknown log level: " + logLevel);
    }

    public static void debug(String name, Object message) {
        NLogger.getLogInstance(name).debug(message);
    }

    public static void debug(Class clazz, Object message) {
        NLogger.getLogInstance(clazz).debug(message);
    }

    public static void debug(String name, Object message, Throwable t) {
        NLogger.getLogInstance(name).debug(message, t);
    }

    public static void debug(Class clazz, Object message, Throwable t) {
        NLogger.getLogInstance(clazz).debug(message, t);
    }

    public static void info(String name, Object message) {
        NLogger.getLogInstance(name).info(message);
    }

    public static void info(Class clazz, Object message) {
        NLogger.getLogInstance(clazz).info(message);
    }

    public static void info(String name, Object message, Throwable t) {
        NLogger.getLogInstance(name).info(message, t);
    }

    public static void warn(String name, Object message) {
        NLogger.getLogInstance(name).warn(message);
    }

    public static void warn(String name, Object message, Throwable t) {
        NLogger.getLogInstance(name).warn(message, t);
    }

    public static void warn(Class clazz, Object message, Throwable t) {
        NLogger.getLogInstance(clazz).warn(message, t);
    }

    public static void warn(Class clazz, Object message) {
        NLogger.getLogInstance(clazz).warn(message);
    }

    public static void error(String name, Object message) {
        NLogger.getLogInstance(name).error(message);
    }

    public static void error(String name, Object message, Throwable t) {
        NLogger.getLogInstance(name).error(message, t);
    }

    public static void error(Class clazz, Object message, Throwable t) {
        NLogger.getLogInstance(clazz).error(message, t);
    }

    public static void log(short logLevel, String name, Object message, Throwable t) {
        switch (logLevel) {
            case 1: {
                NLogger.debug(name, message, t);
                break;
            }
            case 2: {
                NLogger.info(name, message, t);
                break;
            }
            case 3: {
                NLogger.warn(name, message, t);
                break;
            }
            case 4: {
                NLogger.error(name, message, t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level: " + logLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream resIs;
        Properties loggingProperties;
        Properties sysProps;
        block10: {
            sysProps = System.getProperties();
            sysProps.put("org.apache.commons.logging.Log", "phex.utils.PhexLogger");
            factory = LogFactory.getFactory();
            loggingProperties = new Properties();
            resIs = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                resIs = cl.getResourceAsStream("phex/resources/logging.properties");
                if (resIs == null) break block10;
                loggingProperties.load(resIs);
            }
            catch (Throwable th) {
                try {
                    th.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(resIs);
                    throw throwable;
                }
                IOUtil.closeQuietly(resIs);
            }
        }
        IOUtil.closeQuietly(resIs);
        BufferedInputStream fileIs = null;
        try {
            File file = Environment.getInstance().getPhexConfigFile("logging.properties");
            if (file.exists()) {
                fileIs = new BufferedInputStream(new FileInputStream(file));
                loggingProperties.load(fileIs);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            IOUtil.closeQuietly(fileIs);
        }
        sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)loggingProperties);
        LogFactory.releaseAll();
        factory = LogFactory.getFactory();
    }
}

