/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import phex.common.ServiceManager;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public final class Logger {
    public static final LogLevel FINEST = new LogLevel(0);
    public static final LogLevel FINER = new LogLevel(1);
    public static final LogLevel FINE = new LogLevel(2);
    public static final LogLevel CONFIG = new LogLevel(3);
    public static final LogLevel INFO = new LogLevel(4);
    public static final LogLevel WARNING = new LogLevel(5);
    public static final LogLevel SEVERE = new LogLevel(6);
    public static final short GLOBAL = 255;
    public static final short DOWNLOAD = 2;
    public static final short UPLOAD = 4;
    public static final short SEARCH = 8;
    public static final short NETWORK = 16;
    public static final short GUI = 32;
    public static final short PERFORMANCE = 64;
    public static final short DOWNLOAD_NET = 128;
    private static short logLevelValue = Logger.SEVERE.value;
    private static short logType = 1;
    private static Map logResourceMap = new HashMap();

    private Logger() {
    }

    public static void logMessage(LogLevel aVerboseLevel, short aLogType, Object firstArgument) {
        if (logLevelValue > aVerboseLevel.value || (aLogType & logType) == 0) {
            return;
        }
        Object[] arguments = new Object[]{firstArgument};
        Logger.logMessage(aVerboseLevel, aLogType, "log.core.msg", arguments);
    }

    public static void logMessage(LogLevel aVerboseLevel, short aLogType, Throwable aThrowable) {
        if (logLevelValue > aVerboseLevel.value || (aLogType & logType) == 0) {
            return;
        }
        String stackTrace = Logger.getStackTrace(aThrowable);
        Object[] arguments = new Object[]{stackTrace};
        Logger.logMessage(aVerboseLevel, aLogType, "log.core.exp", arguments);
    }

    public static void logMessage(LogLevel aVerboseLevel, short aLogType, Object firstArgument, Object secondArgument) {
        if (logLevelValue > aVerboseLevel.value || (aLogType & logType) == 0) {
            return;
        }
        Object[] arguments = new Object[]{firstArgument, secondArgument};
        Logger.logMessage(aVerboseLevel, aLogType, "log.core.msg2", arguments);
    }

    public static void logMessage(LogLevel aVerboseLevel, short aLogType, String aResource, Object[] arguments) {
        String lookupValue;
        if (logLevelValue > aVerboseLevel.value || (aLogType & logType) == 0) {
            return;
        }
        String formatedString = aResource != null ? ((lookupValue = (String)logResourceMap.get(aResource)) != null ? MessageFormat.format(lookupValue, arguments) : lookupValue) : StringUtils.join(arguments, ";");
        String logTypeName = Logger.getLogTypeName(aLogType);
        formatedString = "(" + logTypeName + ")! " + formatedString;
        switch (aVerboseLevel.value) {
            case 0: 
            case 1: 
            case 2: {
                NLogger.debug(logTypeName, (Object)formatedString);
                break;
            }
            case 3: 
            case 4: {
                NLogger.info(logTypeName, (Object)formatedString);
                break;
            }
            case 5: {
                NLogger.warn(logTypeName, (Object)formatedString);
                break;
            }
            case 6: {
                NLogger.error(logTypeName, formatedString);
            }
        }
    }

    public static void setVerboseLevel(short newLogLevelValue) {
        if (newLogLevelValue >= Logger.FINEST.value && newLogLevelValue <= Logger.SEVERE.value) {
            logLevelValue = newLogLevelValue;
        }
    }

    public static int getVerboseLevel() {
        return logLevelValue;
    }

    public static void setLogType(boolean download, boolean upload, boolean search, boolean network, boolean gui) {
        logType = (short)(1 | (download ? 2 : 0) | (upload ? 4 : 0) | (search ? 8 : 0) | (network ? 16 : 0) | (gui ? 32 : 0));
    }

    public static void setLogType(short aLogType) {
        if (aLogType >= 1 && aLogType <= 255) {
            logType = aLogType;
        }
    }

    public static boolean isTypeLogged(short aLogType) {
        return (aLogType & logType) > 0;
    }

    public static boolean isLevelLogged(LogLevel aLogLevel) {
        return logLevelValue <= aLogLevel.value;
    }

    public static boolean isLevelTypeLogged(LogLevel aLogLevel, short aLogType) {
        if (logLevelValue > aLogLevel.value) {
            return false;
        }
        return (aLogType & logType) > 0;
    }

    private static String getLogTypeName(short logType) {
        switch (logType) {
            case 2: {
                return "Download";
            }
            case 4: {
                return "Upload";
            }
            case 8: {
                return "Search";
            }
            case 16: {
                return "Network";
            }
            case 32: {
                return "GUI";
            }
            case 64: {
                return "Performance";
            }
            case 128: {
                return "Download Net";
            }
            case 255: {
                return "Global";
            }
        }
        return "Unknwon (" + logType + ')';
    }

    private static String getStackTrace(Throwable aThrowable) {
        CharArrayWriter buffer = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(buffer);
        while (aThrowable != null) {
            aThrowable.printStackTrace(printWriter);
            if (aThrowable instanceof InvocationTargetException) {
                aThrowable = ((InvocationTargetException)aThrowable).getTargetException();
                continue;
            }
            aThrowable = null;
        }
        return buffer.toString();
    }

    static {
        logResourceMap.put("log.core.msg", "{0}");
        logResourceMap.put("log.core.msg2", "{0} {1}");
        logResourceMap.put("log.core.exp", "Exception occured: {0}");
        logResourceMap.put("log.core.expmsg", "{1} - Exception: {0}");
        Logger.setVerboseLevel(ServiceManager.sCfg.loggerVerboseLevel);
        Logger.setLogType(ServiceManager.sCfg.logType);
    }

    public static final class LogLevel {
        public final short value;

        public LogLevel(short aLevel) {
            this.value = aLevel;
        }
    }
}

