/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import phex.common.FileHandlingException;
import phex.utils.IOUtil;

public final class FileUtils {
    private static final int BUFFER_LENGTH = 262144;

    private FileUtils() {
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        return FileUtils.getFileExtension(name);
    }

    public static String getFileExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return fileName.substring(idx + 1);
    }

    public static String replaceFileExtension(String fileName, String newExtension) {
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            return fileName + "." + newExtension;
        }
        return fileName.substring(0, idx + 1) + newExtension;
    }

    public static String convertToLocalSystemFilename(String filename) {
        filename = filename.replace('/', '_');
        return filename.substring(0, Math.min(255, filename.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(File destination, File fileToAppend) throws IOException {
        long destFileLength = destination.length();
        long appendFileLength = fileToAppend.length();
        FileInputStream inStream = new FileInputStream(fileToAppend);
        try {
            RandomAccessFile destFile = new RandomAccessFile(destination, "rw");
            try {
                int length;
                destFile.setLength(destFileLength + appendFileLength);
                destFile.seek(destFileLength);
                byte[] buffer = new byte[(int)Math.min(262144L, appendFileLength)];
                while (-1 != (length = inStream.read(buffer))) {
                    long start2 = System.currentTimeMillis();
                    destFile.write(buffer, 0, length);
                    long end2 = System.currentTimeMillis();
                    try {
                        Thread.sleep((end2 - start2) * 2L);
                    }
                    catch (InterruptedException exp) {
                        Thread.currentThread().interrupt();
                        destFile.close();
                        IOUtil.closeQuietly(destFile);
                        IOUtil.closeQuietly(inStream);
                        return;
                    }
                }
            }
            finally {
                destFile.close();
                IOUtil.closeQuietly(destFile);
            }
        }
        finally {
            IOUtil.closeQuietly(inStream);
        }
        boolean succ = fileToAppend.delete();
        if (!succ) {
            fileToAppend.deleteOnExit();
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileUtils.copyFile(source, destination, source.length());
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination + " - " + source.length() + "/" + destination.length();
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination, long copyLength) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new FileNotFoundException(message);
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
            String message = "Unable to write file " + source + " on itself.";
            throw new IOException(message);
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int read;
            long lengthLeft;
            input = new FileInputStream(source);
            output = new FileOutputStream(destination);
            byte[] buffer = new byte[(int)Math.min(262144L, lengthLeft + 1L)];
            for (lengthLeft = copyLength; lengthLeft > 0L && (read = input.read(buffer)) != -1; lengthLeft -= (long)read) {
                output.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(input);
            IOUtil.closeQuietly(output);
            throw throwable;
        }
        IOUtil.closeQuietly(input);
        IOUtil.closeQuietly(output);
        destination.setLastModified(source.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitFile(File source, File destination, long splitPoint) throws IOException {
        RandomAccessFile sourceFile = new RandomAccessFile(source, "rw");
        try {
            FileOutputStream outStream = new FileOutputStream(destination);
            try {
                int length;
                sourceFile.seek(splitPoint);
                byte[] buffer = new byte[(int)Math.min(262144L, source.length() + 1L)];
                while (-1 != (length = sourceFile.read(buffer))) {
                    outStream.write(buffer, 0, length);
                }
                sourceFile.setLength(splitPoint);
            }
            finally {
                IOUtil.closeQuietly(outStream);
            }
        }
        finally {
            IOUtil.closeQuietly(sourceFile);
        }
    }

    public static void renameLocalFile(File currentFile, File newFile) throws FileHandlingException {
        if (newFile.exists()) {
            throw new FileHandlingException(1);
        }
        if (currentFile.exists() && !currentFile.renameTo(newFile)) {
            throw new FileHandlingException(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateFile(File file, long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("File size < 0: " + size);
        }
        if (file.exists() && file.length() > size) {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            try {
                raf.setLength(size);
            }
            finally {
                IOUtil.closeQuietly(raf);
            }
        }
    }

    public static boolean isChildOfDir(File maybeChild, File maybeParentDir) {
        if (!maybeChild.getAbsolutePath().startsWith(maybeParentDir.getAbsolutePath())) {
            return false;
        }
        return FileUtils.isChildOfDirInternal(maybeChild, maybeParentDir);
    }

    private static boolean isChildOfDirInternal(File maybeChild, File maybeParentDir) {
        File parent = maybeChild.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.equals(maybeParentDir)) {
            return true;
        }
        return FileUtils.isChildOfDirInternal(parent, maybeParentDir);
    }
}

