/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import phex.common.Environment;
import phex.utils.DirectByteBuffer;
import phex.utils.NLogger;

public class DirectByteBufferProvider {
    public static final int BUFFER_SIZE_64K = 65536;
    private static final DirectByteBufferProvider instance = new DirectByteBufferProvider();
    private Map sizeToBufferListMap = new LinkedHashMap();
    private static final long MAX_TOTAL_BUFFER_SIZE = 0xA00000L;

    private DirectByteBufferProvider() {
        Environment.getInstance().scheduleTimerTask(new CleanupCheckerTask(), 600000L, 600000L);
    }

    public static DirectByteBuffer requestBuffer(int sizeInBytes) {
        return instance.requestDirectByteBuffer(sizeInBytes);
    }

    protected synchronized void releaseDirectByteBuffer(DirectByteBuffer directByteBuffer) {
        this.debugDump();
        ByteBuffer buffer = directByteBuffer.getInternalBuffer();
        int kb = (int)Math.ceil((double)buffer.capacity() / 1024.0);
        Integer key = new Integer(kb);
        HashSet<DirectByteBuffer> set = (HashSet<DirectByteBuffer>)this.sizeToBufferListMap.get(key);
        if (set == null) {
            set = new HashSet<DirectByteBuffer>();
            this.sizeToBufferListMap.put(key, set);
        }
        set.add(directByteBuffer);
        this.debugDump();
    }

    private synchronized DirectByteBuffer requestDirectByteBuffer(int capacity) {
        DirectByteBuffer directByteBuffer;
        this.debugDump();
        int kb = (int)Math.ceil((double)capacity / 1024.0);
        Integer key = new Integer(kb);
        HashSet set = (HashSet)this.sizeToBufferListMap.get(key);
        if (set == null) {
            set = new HashSet();
            this.sizeToBufferListMap.put(key, set);
        }
        if (set.isEmpty()) {
            directByteBuffer = this.allocateDirectByteBuffer(kb * 1024);
        } else {
            directByteBuffer = (DirectByteBuffer)set.iterator().next();
            set.remove(directByteBuffer);
        }
        ByteBuffer buffer = directByteBuffer.getInternalBuffer();
        buffer.clear();
        buffer.limit(capacity);
        this.debugDump();
        return directByteBuffer;
    }

    private synchronized DirectByteBuffer allocateDirectByteBuffer(int capacity) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ByteBuffer.allocateDirect(capacity);
        }
        catch (OutOfMemoryError err) {
            this.clearBuffers();
            System.runFinalization();
            System.gc();
            Thread.yield();
            try {
                byteBuffer = ByteBuffer.allocateDirect(capacity);
            }
            catch (OutOfMemoryError err2) {
                NLogger.error("GLOBAL", "Out of memory while trying to allocated direct byte buffer.");
                throw err2;
            }
        }
        DirectByteBuffer directByteBuffer = new DirectByteBuffer(byteBuffer, this);
        return directByteBuffer;
    }

    private synchronized void clearBuffers() {
        Iterator iterator = this.sizeToBufferListMap.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            list.clear();
        }
    }

    private synchronized void cleanupChecker() {
        long bytesUsed = 0L;
        Iterator iterator = this.sizeToBufferListMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer key = (Integer)iterator.next();
            HashSet set = (HashSet)this.sizeToBufferListMap.get(key);
            bytesUsed += (long)(key * set.size() * 1024);
        }
        if (bytesUsed > 0xA00000L) {
            this.performCleanup(bytesUsed - 0xA00000L);
        }
    }

    private synchronized void performCleanup(long bytesToFree) {
        int mapSize = this.sizeToBufferListMap.size();
        int highestCount = 0;
        int[] bufferSizeArr = new int[mapSize];
        List[] bufferListArr = new List[mapSize];
        int i = 0;
        Iterator listIterator = this.sizeToBufferListMap.keySet().iterator();
        while (listIterator.hasNext()) {
            Integer key = (Integer)listIterator.next();
            List list = (List)this.sizeToBufferListMap.get(key);
            bufferSizeArr[i] = key * 1024;
            bufferListArr[i] = list;
            int listSize = list.size();
            if (listSize > highestCount) {
                highestCount = listSize;
            }
            ++i;
        }
        long bytesFreed = 0L;
        while (bytesFreed < bytesToFree && highestCount > 0) {
            for (i = 0; i < mapSize; ++i) {
                if (bufferListArr[i].size() != highestCount) continue;
                bufferListArr[i].remove(bufferListArr[i].size() - 1);
                bytesFreed += (long)bufferSizeArr[i];
            }
            --highestCount;
        }
    }

    private synchronized void debugDump() {
    }

    private class CleanupCheckerTask
    extends TimerTask {
        private static final int TIMER_PERIOD = 600000;

        private CleanupCheckerTask() {
        }

        public void run() {
            DirectByteBufferProvider.this.cleanupChecker();
        }
    }
}

