/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.OutputStream;
import phex.common.bandwidth.BandwidthController;

public class BandwidthOutputStream
extends OutputStream {
    private OutputStream outStream;
    private BandwidthController bandwidthController;

    public BandwidthOutputStream(OutputStream outStream, BandwidthController aBandwidthController) {
        this.outStream = outStream;
        this.bandwidthController = aBandwidthController;
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
    }

    public void write(int b) throws IOException {
        this.bandwidthController.getAvailableByteCount(true);
        this.outStream.write(b);
        this.bandwidthController.markBytesUsed(1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int available = this.bandwidthController.getAvailableByteCount(len, true);
            this.outStream.write(b, off, available);
            this.bandwidthController.markBytesUsed(available);
            len -= available;
            off += available;
        }
    }

    public void flush() throws IOException {
        this.outStream.flush();
    }

    public void close() throws IOException {
        this.outStream.flush();
    }
}

