/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.util.ArrayList;
import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.log.LogBuffer;
import phex.event.AsynchronousDispatcher;
import phex.event.UploadFilesChangeListener;
import phex.http.HTTPRequest;
import phex.net.connection.Connection;
import phex.upload.UploadEngine;
import phex.upload.UploadState;
import phex.utils.NLogger;

public class UploadManager
extends AbstractManager {
    private LogBuffer uploadStateLogBuffer;
    private IPCounter uploadIPCounter;
    private ArrayList uploadStateList;
    private ArrayList queuedStateList;
    private ArrayList listenerList = new ArrayList(2);

    private UploadManager() {
        this.uploadIPCounter = new IPCounter(ServiceManager.sCfg.mMaxUploadPerIP);
        this.uploadStateList = new ArrayList();
        this.queuedStateList = new ArrayList();
    }

    public static UploadManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        if (ServiceManager.sCfg.uploadStateLogBufferSize > 0L) {
            this.uploadStateLogBuffer = new LogBuffer(ServiceManager.sCfg.uploadStateLogBufferSize);
        }
        return true;
    }

    public boolean onPostInitialization() {
        Environment.getInstance().scheduleTimerTask(new CleanUploadStateTimer(), 10000L, 10000L);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void handleUploadRequest(Connection connection, HTTPRequest httpRequest) {
        UploadEngine uploadEngine = new UploadEngine(connection, httpRequest);
        uploadEngine.startUpload();
    }

    public boolean isHostBusy() {
        return this.getUploadingCount() >= ServiceManager.sCfg.mMaxUpload;
    }

    public boolean isQueueLimitReached() {
        return this.queuedStateList.size() >= ServiceManager.sCfg.maxUploadQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndCountIP(DestAddress hostAddress) {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            this.uploadIPCounter.setMaxCount(ServiceManager.sCfg.mMaxUploadPerIP);
            return this.uploadIPCounter.validateAndCountIP(hostAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUploadIP(DestAddress hostAddress) {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            this.uploadIPCounter.relaseIP(hostAddress);
        }
    }

    public LogBuffer getUploadStateLogBuffer() {
        return this.uploadStateLogBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadState(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int position = this.uploadStateList.size();
            this.uploadStateList.add(uploadState);
            this.fireUploadFileAdded(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUploadState(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            return this.uploadStateList.contains(uploadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadListSize() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            return this.uploadStateList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingCount() {
        int count = 0;
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState state = (UploadState)this.uploadStateList.get(i);
                if (state.getStatus() != 2 && state.getStatus() != 0) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState getUploadStateAt(int index) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            if (index < 0 || index >= this.uploadStateList.size()) {
                return null;
            }
            return (UploadState)this.uploadStateList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState[] getUploadStatesAt(int[] indices) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int length = indices.length;
            UploadState[] states = new UploadState[length];
            int listSize = this.uploadStateList.size();
            for (int i = 0; i < length; ++i) {
                states[i] = indices[i] < 0 || indices[i] >= listSize ? null : (UploadState)this.uploadStateList.get(indices[i]);
            }
            return states;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUploadState(UploadState state) {
        int idx;
        state.stopUpload();
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            idx = this.uploadStateList.indexOf(state);
            if (idx != -1) {
                this.uploadStateList.remove(idx);
                this.fireUploadFileRemoved(idx);
            }
        }
        arrayList = this.queuedStateList;
        synchronized (arrayList) {
            idx = this.queuedStateList.indexOf(state);
            if (idx != -1) {
                this.queuedStateList.remove(idx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUploadStateList() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState state = (UploadState)this.uploadStateList.get(i);
                short status = state.getStatus();
                if (status == 2 || status == 0) continue;
                this.uploadStateList.remove(i);
                this.fireUploadFileRemoved(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addQueuedUpload(UploadState uploadState) {
        int position;
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            position = this.queuedStateList.size();
            this.queuedStateList.add(uploadState);
        }
        this.fireUploadQueueChanged();
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedUpload(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            int position = this.queuedStateList.indexOf(uploadState);
            if (position != -1) {
                this.queuedStateList.remove(position);
                this.fireUploadQueueChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedPosition(UploadState state) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.indexOf(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadQueueSize() {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.size();
        }
    }

    public void addUploadFilesChangeListener(UploadFilesChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeUploadFilesChangeListener(UploadFilesChangeListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireUploadFileChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = UploadManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener listener = (UploadFilesChangeListener)listeners[i];
                    listener.uploadFileChanged(position);
                }
            }
        });
    }

    private void fireUploadFileAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = UploadManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener listener = (UploadFilesChangeListener)listeners[i];
                    listener.uploadFileAdded(position);
                }
            }
        });
    }

    private void fireUploadQueueChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = UploadManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener listener = (UploadFilesChangeListener)listeners[i];
                    listener.uploadQueueChanged();
                }
            }
        });
    }

    private void fireUploadFileRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = UploadManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener listener = (UploadFilesChangeListener)listeners[i];
                    listener.uploadFileRemoved(position);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUploadFileChanged(UploadState file) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int position = this.uploadStateList.indexOf(file);
            if (position >= 0) {
                this.fireUploadFileChanged(position);
            }
        }
    }

    private class CleanUploadStateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private CleanUploadStateTimer() {
        }

        public void run() {
            try {
                if (ServiceManager.sCfg.mUploadAutoRemoveCompleted) {
                    UploadManager.this.cleanUploadStateList();
                }
            }
            catch (Throwable th) {
                NLogger.error("UPLOAD", (Object)th, th);
            }
        }
    }

    private static class Holder {
        protected static final UploadManager manager = new UploadManager();

        private Holder() {
        }
    }
}

