/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import phex.common.ThreadPool;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.msg.PushRequestMsg;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.SocketFacade;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.statistic.UploadDownloadCountStatistic;
import phex.upload.UploadManager;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;

public class PushWorker
implements Runnable {
    private static final int PUSH_TIMEOUT = 45000;
    private final PushRequestMsg pushMsg;
    private Connection connection;

    public PushWorker(PushRequestMsg msg) {
        this.pushMsg = msg;
        ThreadPool.getInstance().addJob(this, "PushWorker-" + Integer.toHexString(this.hashCode()));
        UploadDownloadCountStatistic.pushUploadAttempts.increment(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            HTTPRequest httpRequest = this.connectAndGetRequest();
            if (httpRequest == null) {
                UploadDownloadCountStatistic.pushUploadFailure.increment(1);
                return;
            }
            this.handleRequest(httpRequest);
            Logger.logMessage(Logger.FINER, (short)4, "PushWorker finished");
        }
        catch (Exception exp) {
            NLogger.error("PUSH", (Object)exp, (Throwable)exp);
            return;
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    private void handleRequest(HTTPRequest httpRequest) {
        Logger.logMessage(Logger.FINE, (short)4, "Handle PUSH request: " + httpRequest.buildHTTPRequestString());
        UploadDownloadCountStatistic.pushUploadSuccess.increment(1);
        if (httpRequest.isGnutellaRequest()) {
            UploadManager.getInstance().handleUploadRequest(this.connection, httpRequest);
        } else {
            ShareManager.getInstance().httpRequestHandler(this.connection, httpRequest);
        }
    }

    private HTTPRequest connectAndGetRequest() {
        try {
            Logger.logMessage(Logger.FINE, (short)4, "Try PUSH connect to: " + this.pushMsg.getRequestAddress());
            SocketFacade sock = OIOSocketFactory.connect(this.pushMsg.getRequestAddress(), 45000);
            BandwidthController bwController = BandwidthManager.getInstance().getUploadBandwidthController();
            this.connection = new Connection(sock, bwController);
            this.sendGIV(this.connection);
            HTTPRequest httpRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            return httpRequest;
        }
        catch (IOException exp) {
            Logger.logMessage(Logger.FINER, (short)4, exp);
            return null;
        }
        catch (HTTPMessageException exp) {
            Logger.logMessage(Logger.FINER, (short)4, exp);
            return null;
        }
    }

    private void sendGIV(Connection connection) throws IOException {
        ShareManager shareMgr = ShareManager.getInstance();
        ShareFile sfile = shareMgr.getSharedFilesService().getFileByIndex((int)this.pushMsg.getFileIndex());
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("GIV ");
        buffer.append(this.pushMsg.getFileIndex());
        buffer.append(':');
        buffer.append(this.pushMsg.getClientGUID().toHexString());
        buffer.append('/');
        if (sfile != null) {
            buffer.append(URLCodecUtils.encodeURL(sfile.getFileName()));
        }
        Logger.logMessage(Logger.FINE, (short)4, "Send GIV: " + buffer.toString());
        byte[] buf = new byte[buffer.length() + 2];
        int len = IOUtil.serializeString(buffer.toString(), buf, 0);
        buf[len++] = 10;
        buf[len++] = 10;
        connection.write(buf, 0, len);
        connection.flush();
    }
}

