/*
 * Decompiled with CFR 0.152.
 */
package phex.udp.hostcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.NetworkManager;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheComparator;
import phex.utils.IPUtils;
import phex.utils.NLogger;

public class UdpHostCacheContainer {
    private static int MIN_UDP_HOST_CACHE_SIZE = 20;
    private List functionalUdpCaches = new ArrayList();
    private List generalUdpCaches = new ArrayList();
    private static final List defaultCaches = new ArrayList();
    public static final Comparator cacheComparator = new UdpHostCacheComparator();

    public UdpHostCacheContainer() {
        NLogger.debug("UDP_HOST_CACHE", (Object)" Started up UDP HOST CACHE CONTAINER ");
    }

    public void initialize() {
        this.functionalUdpCaches.clear();
        this.generalUdpCaches.clear();
        this.loadCachesFromFile();
        this.generalUdpCaches.addAll(defaultCaches);
        NLogger.debug("UDP_HOST_CACHE", (Object)" Initialized UDP HOST CACHE CONTAINER ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFunctionalCache(UdpHostCache cache) {
        List list = this.generalUdpCaches;
        synchronized (list) {
            if (this.generalUdpCaches.contains(cache)) {
                this.generalUdpCaches.remove(cache);
            }
        }
        cache.resetFailCount();
        NLogger.info("UDP_HOST_CACHE", (Object)" Adding a UDP Host Cache to the FUNCTIONAL Container");
        return this.addTo(cache, this.functionalUdpCaches);
    }

    public boolean addCache(UdpHostCache cache) {
        int hostCacheCount = this.generalUdpCaches.size() + this.functionalUdpCaches.size();
        if (cache.getFailCount() >= 3 && hostCacheCount > MIN_UDP_HOST_CACHE_SIZE) {
            NLogger.info("UDP_HOST_CACHE", (Object)(" Udp host cache dropped due to failure count : " + cache));
            return false;
        }
        NLogger.info("UDP_HOST_CACHE", (Object)" Adding a UDP Host Cache to the GENERAL HOST CACHE CONTAINER ");
        return this.addTo(cache, this.generalUdpCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPackedHostCaches() {
        int PACKED_CACHES_SIZE = 8;
        StringBuffer packedCaches = new StringBuffer(168);
        List list = this.functionalUdpCaches;
        synchronized (list) {
            Iterator udphc = this.functionalUdpCaches.iterator();
            for (int count = 0; udphc.hasNext() && count < 8; ++count) {
                UdpHostCache cache = (UdpHostCache)udphc.next();
                DestAddress address = cache.getHostAddress();
                String ipString = address.getFullHostName();
                packedCaches.append(ipString);
                packedCaches.append("\n");
            }
        }
        return packedCaches.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryMoreHosts() {
        UdpHostCache cache;
        List list;
        int i;
        int NO_OF_CACHES_TO_PING = 3;
        int pingedCacheCount = 0;
        for (i = 0; i < 2; ++i) {
            list = this.functionalUdpCaches;
            synchronized (list) {
                if (this.functionalUdpCaches.isEmpty()) {
                    break;
                }
                cache = (UdpHostCache)this.functionalUdpCaches.remove(0);
                if (cache != null) {
                    this.queryCache(cache);
                    ++pingedCacheCount;
                }
                continue;
            }
        }
        for (i = pingedCacheCount; i <= 3; ++i) {
            list = this.generalUdpCaches;
            synchronized (list) {
                if (this.generalUdpCaches.isEmpty()) {
                    break;
                }
                cache = (UdpHostCache)this.generalUdpCaches.remove(0);
                if (cache != null) {
                    this.queryCache(cache);
                }
                continue;
            }
        }
    }

    private void queryCache(UdpHostCache cache) {
        NLogger.info("UDP_HOST_CACHE", (Object)(" Pinging UDP Host Cache :" + cache));
        cache.pingCache();
        cache.incrementFailCount();
        this.addCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCachesFromFile() {
        try {
            NetworkManager networkMgr = NetworkManager.getInstance();
            File file = networkMgr.getGnutellaNetwork().getUdpHostCacheFile();
            if (!file.exists()) {
                NLogger.debug(UdpHostCacheContainer.class, (Object)"No UDP host cache file found.");
                return;
            }
            PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
            BufferedReader br = new BufferedReader(new FileReader(file));
            List list = this.generalUdpCaches;
            synchronized (list) {
                String line;
                block10: while ((line = br.readLine()) != null) {
                    DestAddress hostCacheAdr;
                    if (line.startsWith("#")) continue;
                    try {
                        hostCacheAdr = PresentationManager.getInstance().createHostAddress(line, 6346);
                    }
                    catch (MalformedDestAddressException e) {
                        NLogger.warn("UDP_HOST_CACHE", (Object)(" Could not create cache to add to the container from the host string : " + line), (Throwable)e);
                        continue;
                    }
                    byte access = securityMgr.controlHostAddressAccess(hostCacheAdr);
                    switch (access) {
                        case 2: 
                        case 3: {
                            continue block10;
                        }
                    }
                    if (IPUtils.isPortInUserInvalidList(hostCacheAdr)) continue;
                    UdpHostCache cache = new UdpHostCache(hostCacheAdr);
                    this.addCache(cache);
                }
            }
            br.close();
        }
        catch (IOException e) {
            NLogger.warn("UDP_HOST_CACHE", (Object)" Loading Udp Host Caches  from file FAILED ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTo(UdpHostCache cache, List cacheContainer) {
        List list = cacheContainer;
        synchronized (list) {
            if (!cacheContainer.contains(cache)) {
                cacheContainer.add(cache);
                Collections.sort(cacheContainer, cacheComparator);
                NLogger.info("UDP_HOST_CACHE", (Object)(" Added UdpHostCache  : " + cache));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(UdpHostCache cache, List cacheContainer) {
        List list = cacheContainer;
        synchronized (list) {
            if (cacheContainer.contains(cache)) {
                cacheContainer.remove(cache);
            }
            cacheContainer.add(cache);
            Collections.sort(cacheContainer, cacheComparator);
            NLogger.info("UDP_HOST_CACHE", (Object)(" Added UdpHostCache  : " + cache));
            return true;
        }
    }

    public void saveCachesToFile() {
        try {
            NetworkManager networkMgr = NetworkManager.getInstance();
            File file = networkMgr.getGnutellaNetwork().getUdpHostCacheFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            this.writeCachesToFile(writer, this.functionalUdpCaches);
            this.writeCachesToFile(writer, this.generalUdpCaches);
            writer.flush();
            writer.close();
        }
        catch (IOException exp) {
            NLogger.warn("UDP_HOST_CACHE", (Object)" Saving Udp Host Caches  to file FAILED ", (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachesToFile(BufferedWriter writer, List cacheContainer) throws IOException {
        List list = cacheContainer;
        synchronized (list) {
            Iterator udpHC = cacheContainer.iterator();
            while (udpHC.hasNext()) {
                UdpHostCache cache = (UdpHostCache)udpHC.next();
                DestAddress address = cache.getHostAddress();
                String ipString = address.getFullHostName();
                writer.write(ipString);
                writer.newLine();
            }
        }
    }
}

