/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import phex.common.address.DestAddress;
import phex.msg.Message;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.utils.PriorityQueue;

public class UdpMsgQueue {
    private static final int PING_QUEUE_SIZE = 15;
    private static final int PONG_QUEUE_SIZE = 20;
    private static final int PING_PRIORITY = 0;
    private static final int PONG_PRIORITY = 1;
    private PriorityQueue queue;

    public UdpMsgQueue() {
        int[] priorities = new int[]{15, 20};
        this.queue = new PriorityQueue(priorities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessage(Message Msg, DestAddress hostAddr) {
        int priority = -1;
        if (Msg == null) {
            return false;
        }
        if (Msg instanceof PingMsg) {
            priority = 0;
        }
        if (Msg instanceof PongMsg) {
            priority = 1;
        }
        if (priority < 0) {
            return false;
        }
        QueueElement element = new QueueElement(Msg, hostAddr);
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.addToHead(element, priority);
            this.queue.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueElement removeMessage() {
        QueueElement element = null;
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            while (this.queue.isEmpty()) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            element = (QueueElement)this.queue.removeMaxPriority();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull(int priority) {
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.isFull(priority);
        }
    }

    public class QueueElement {
        private Message msg;
        private DestAddress address;

        public QueueElement(Message message, DestAddress addr) {
            this.msg = message;
            this.address = addr;
        }

        public Message getMsg() {
            return this.msg;
        }

        public DestAddress getAddress() {
            return this.address;
        }
    }
}

