/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import phex.common.PongCache;
import phex.common.ThreadTracking;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.NetworkManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.security.PhexSecurityManager;
import phex.udp.UdpGuidRoutingTable;
import phex.udp.UdpMsgQueue;
import phex.utils.NLogger;

public class UdpMessageEngine {
    public static final int MAX_PACKET_SIZE = 1024;
    public static final int MAX_RECV_BUFFER_SIZE = 16384;
    private DatagramSocket udpSocket;
    private UdpMsgQueue sendQueue = new UdpMsgQueue();
    private UdpGuidRoutingTable pingRoutingTable;
    private final HostManager hostMgr;
    private final PhexSecurityManager securityManager = PhexSecurityManager.getInstance();

    public UdpMessageEngine() {
        this.hostMgr = HostManager.getInstance();
        this.pingRoutingTable = new UdpGuidRoutingTable(30000L);
        int port = NetworkManager.getInstance().getLocalAddress().getPort();
        try {
            this.udpSocket = new DatagramSocket(port);
            this.udpSocket.setReceiveBufferSize(16384);
        }
        catch (SocketException e) {
            NLogger.warn("UDP_CONNECTION", (Object)(" Couldnt bind to port " + port), (Throwable)e);
            return;
        }
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, new Reciever(), "UDP Message Receiver");
        thread.start();
        thread = new Thread(ThreadTracking.rootThreadGroup, new Sender(), "UDP Message Sender");
        thread.start();
    }

    public boolean addMessageToSend(Message msg, DestAddress hostAddr) {
        if (msg == null) {
            return false;
        }
        return this.sendQueue.addMessage(msg, hostAddr);
    }

    private DatagramPacket getDatagramToSend() {
        UdpMsgQueue.QueueElement element = this.sendQueue.removeMessage();
        Message msg = element.getMsg();
        DestAddress address = element.getAddress();
        byte[] data = null;
        if (msg instanceof PingMsg) {
            GUID guid = msg.getHeader().getMsgID();
            if (!this.pingRoutingTable.checkAndAddRouting(guid, address)) {
                NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)(" ping with duplicate guid not sent " + guid + " for message : " + msg));
                return null;
            }
            PingMsg ping = (PingMsg)msg;
            data = ping.getBytes();
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" guid : " + guid + " successfully added to routing table for " + " udp ping : \n " + msg));
        }
        if (msg instanceof PongMsg) {
            PongMsg pong = (PongMsg)msg;
            data = pong.getbytes();
        }
        if (data == null) {
            return null;
        }
        try {
            IpAddress ipAddress = address.getIpAddress();
            InetAddress ipAddr = ipAddress != null ? InetAddress.getByAddress(ipAddress.getHostIP()) : InetAddress.getByName(address.getHostName());
            int port = address.getPort();
            DatagramPacket packet = new DatagramPacket(data, data.length, ipAddr, port);
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" created udp datagram for msg " + msg + " \n to " + ipAddr));
            return packet;
        }
        catch (UnknownHostException e) {
            NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)(" Could not create datagram  from message : " + msg), (Throwable)e);
            return null;
        }
    }

    public DatagramPacket readMessage() {
        byte[] data = new byte[1024];
        DatagramPacket packet = new DatagramPacket(data, data.length);
        try {
            this.udpSocket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            NLogger.warn("UDP_CONNECTION", (Object)(" Could not read from udp socket " + this.udpSocket.getLocalSocketAddress()), (Throwable)e);
            return null;
        }
    }

    private void handlePing(MsgHeader header, byte[] data, Host fromHost) {
        PingMsg udpPing = null;
        try {
            udpPing = PingMsg.createUdpPingMsg(header, data, 23, fromHost);
            NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recieved Udp Ping Msg From " + fromHost + " : " + udpPing));
        }
        catch (InvalidMessageException e) {
            return;
        }
        this.respondToPing(udpPing);
    }

    private void respondToPing(PingMsg udpPing) {
        PongMsg pong = PongMsg.createUdpPongMsg(udpPing);
        DestAddress address = udpPing.getHeader().getFromHost().getHostAddress();
        this.addMessageToSend(pong, address);
        NLogger.info("UDP_OUTGOING_MESSAGES", (Object)("added to send queue Udp Pong :" + pong + " \n \t to " + address));
    }

    private void handlePong(MsgHeader header, byte[] data, Host fromHost) {
        boolean isNew;
        GUID guid = header.getMsgID();
        DestAddress address = this.pingRoutingTable.getAndRemoveRouting(guid);
        if (address == null) {
            NLogger.warn("UDP_INCOMING_MESSAGES", (Object)(" Recieved Udp Pong  with Guid not found in the routing table : " + header + " \n \t Ignoring pong"));
            return;
        }
        PongMsg udpPong = null;
        try {
            udpPong = PongMsg.createUdpPongMsg(header, data, 23, fromHost);
            NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recieved Udp Pong Msg From " + fromHost + " : " + udpPong));
        }
        catch (InvalidMessageException e) {
            return;
        }
        byte[] pongIP = udpPong.getIP();
        byte access = this.securityManager.controlHostIPAccess(pongIP);
        if (access == 3) {
            return;
        }
        if (access == 1 && (isNew = this.hostMgr.getCaughtHostsContainer().addCaughtHost(udpPong))) {
            PongCache.getInstance().addPong(udpPong);
        }
    }

    class Reciever
    implements Runnable {
        Reciever() {
        }

        public void run() {
            block6: while (true) {
                DatagramPacket packet;
                if ((packet = UdpMessageEngine.this.readMessage()) == null) {
                    continue;
                }
                byte[] packetData = packet.getData();
                int pktDataLength = packet.getLength();
                byte[] ip = packet.getAddress().getAddress();
                int port = packet.getPort();
                DefaultDestAddress address = new DefaultDestAddress(ip, port);
                if (pktDataLength < 23) continue;
                Host fromHost = UdpMessageEngine.this.hostMgr.getNetworkHostsContainer().getNetworkHost(address);
                if (fromHost == null) {
                    fromHost = new Host(address);
                }
                MsgHeader header = null;
                try {
                    header = MsgHeader.createMsgHeader(packetData, 0);
                }
                catch (Exception e) {
                    NLogger.warn("UDP_INCOMING_MESSAGES", (Object)" Failed to create udp pong from datagram ", (Throwable)e);
                }
                if (header.getDataLength() > pktDataLength - 23) {
                    NLogger.warn("UDP_INCOMING_MESSAGES", (Object)" Msg Header Data length is invalid ");
                }
                switch (header.getPayload()) {
                    case 0: {
                        NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recvd Ping from : " + address));
                        UdpMessageEngine.this.handlePing(header, packetData, fromHost);
                        continue block6;
                    }
                    case 1: {
                        NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recvd Pong from : " + address));
                        UdpMessageEngine.this.handlePong(header, packetData, fromHost);
                        continue block6;
                    }
                }
                NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recvd unrecognized Msg from : " + address));
            }
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        public void run() {
            while (true) {
                DatagramPacket packet;
                if ((packet = UdpMessageEngine.this.getDatagramToSend()) == null) {
                    continue;
                }
                try {
                    UdpMessageEngine.this.udpSocket.send(packet);
                    continue;
                }
                catch (IOException e) {
                    NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)("Sending udp message " + packet + "failed "), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

