/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.util.Map;
import java.util.TreeMap;
import phex.common.address.DestAddress;
import phex.msg.GUID;

public class UdpGuidRoutingTable {
    private static final int MAX_ROUTE_TABLE_SIZE = 50;
    protected Map currentMap;
    protected Map lastMap;
    private long lifetime;
    private long nextReplaceTime;

    public UdpGuidRoutingTable(long lifetime) {
        this.lifetime = lifetime;
        this.currentMap = new TreeMap(new GUID.GUIDComparator());
        this.lastMap = new TreeMap(new GUID.GUIDComparator());
    }

    public synchronized boolean checkAndAddRouting(GUID guid, DestAddress address) {
        this.checkForSwitch();
        if (!this.currentMap.containsKey(guid) && !this.lastMap.containsKey(guid)) {
            this.currentMap.put(guid, address);
            return true;
        }
        return false;
    }

    protected void checkForSwitch() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextReplaceTime && this.currentMap.size() < 50) {
            return;
        }
        this.lastMap.clear();
        Map temp = this.lastMap;
        this.lastMap = this.currentMap;
        this.currentMap = temp;
        this.nextReplaceTime = currentTime + this.lifetime;
    }

    public synchronized DestAddress getRouting(GUID guid) {
        DestAddress address = null;
        address = (DestAddress)this.currentMap.get(guid);
        if (address != null) {
            return address;
        }
        address = (DestAddress)this.lastMap.get(guid);
        if (address != null) {
            return address;
        }
        return null;
    }

    public synchronized DestAddress getAndRemoveRouting(GUID guid) {
        DestAddress address = null;
        address = (DestAddress)this.currentMap.remove(guid);
        if (address != null) {
            return address;
        }
        address = (DestAddress)this.lastMap.remove(guid);
        if (address != null) {
            return address;
        }
        return null;
    }
}

