/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.common.format.TimeFormatUtils;
import phex.statistic.StatisticProvider;

public class UptimeStatisticProvider
implements StatisticProvider {
    private long startTime;
    private LongObj valueObj = new LongObj();
    private LongObj avgObj = new LongObj();
    private LongObj maxObj;

    public UptimeStatisticProvider() {
        this.maxObj = new LongObj(ServiceManager.sCfg.maximalUptime);
        this.startUptimeMeasurement();
    }

    private void startUptimeMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    public Object getValue() {
        long value = System.currentTimeMillis() - this.startTime;
        this.valueObj.setValue(value);
        return this.valueObj;
    }

    public Object getAverageValue() {
        LongObj currentUptimeObj = (LongObj)this.getValue();
        long currentUptime = currentUptimeObj.longValue();
        currentUptime = Math.max(currentUptime, 0L);
        long avgUptime = (currentUptime + ServiceManager.sCfg.movingTotalUptime) / (long)(ServiceManager.sCfg.movingTotalUptimeCount + 1);
        this.avgObj.setValue(avgUptime);
        return this.avgObj;
    }

    public Object getMaxValue() {
        long uptime = System.currentTimeMillis() - this.startTime;
        if (uptime > this.maxObj.getValue()) {
            this.maxObj.setValue(uptime);
        }
        return this.maxObj;
    }

    public String toStatisticString(Object value) {
        return TimeFormatUtils.formatSignificantElapsedTime(((LongObj)value).longValue() / 1000L);
    }

    public void saveUptimeStats() {
        LongObj obj = (LongObj)this.getMaxValue();
        ServiceManager.sCfg.maximalUptime = obj.getValue();
        if (ServiceManager.sCfg.movingTotalUptimeCount >= 25) {
            ServiceManager.sCfg.movingTotalUptime -= ServiceManager.sCfg.movingTotalUptime / (long)ServiceManager.sCfg.movingTotalUptimeCount;
            --ServiceManager.sCfg.movingTotalUptimeCount;
        }
        if ((obj = (LongObj)this.getValue()).longValue() > 0L) {
            ServiceManager.sCfg.movingTotalUptime += obj.longValue();
            ++ServiceManager.sCfg.movingTotalUptimeCount;
        }
    }
}

