/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.XMLUtils;

public class SharedFilesPipeFiller
implements Runnable {
    private Writer utf8Writer;
    private Map exportOptions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedFilesPipeFiller(OutputStream outStream, Map options) {
        block2: {
            try {
                this.utf8Writer = new OutputStreamWriter(outStream, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.exportOptions = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            DestAddress localAddress = NetworkManager.getInstance().getLocalAddress();
            this.utf8Writer.write("<shared-file-export>");
            if (this.exportOptions != null && this.exportOptions.size() > 0) {
                this.utf8Writer.write("<export-options>");
                Iterator optionIterator = this.exportOptions.keySet().iterator();
                while (optionIterator.hasNext()) {
                    String optionName = (String)optionIterator.next();
                    this.utf8Writer.write("<option name='" + optionName + "'>");
                    this.utf8Writer.write(this.exportOptions.get(optionName).toString());
                    this.utf8Writer.write("</option>");
                }
                this.utf8Writer.write("</export-options>");
            }
            this.utf8Writer.write("<shared-file-list>");
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            ShareFile[] sharedFiles = sharedFilesService.getSharedFiles();
            for (int i = 0; i < sharedFiles.length; ++i) {
                ShareFile file = sharedFiles[i];
                URN urn = file.getURN();
                if (urn == null) continue;
                this.utf8Writer.write("<shared-file>");
                this.utf8Writer.write("<index>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getFileIndex()));
                this.utf8Writer.write("</index>");
                this.utf8Writer.write("<name>");
                XMLUtils.writeEncoded(this.utf8Writer, file.getFileName());
                this.utf8Writer.write("</name>");
                this.utf8Writer.write("<name-urlenc>");
                XMLUtils.writeEncoded(this.utf8Writer, URLCodecUtils.encodeURL(file.getFileName()));
                this.utf8Writer.write("</name-urlenc>");
                this.utf8Writer.write("<search-compare-term>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getSearchCompareTerm()));
                this.utf8Writer.write("</search-compare-term>>");
                this.utf8Writer.write("<search-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getSearchCount()));
                this.utf8Writer.write("</search-count>");
                this.utf8Writer.write("<sha1>");
                XMLUtils.writeEncoded(this.utf8Writer, file.getSHA1());
                this.utf8Writer.write("</sha1>");
                this.utf8Writer.write("<upload-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getUploadCount()));
                this.utf8Writer.write("</upload-count>");
                this.utf8Writer.write("<file-size>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getFileSize()));
                this.utf8Writer.write("</file-size>");
                this.utf8Writer.write("<urn>");
                XMLUtils.writeEncoded(this.utf8Writer, urn.getAsString());
                this.utf8Writer.write("</urn>");
                this.utf8Writer.write("<magnet-url>");
                if (this.exportOptions != null && "true".equals(this.exportOptions.get("UseMagnetURLWithXS"))) {
                    XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURLWithXS(file.getSHA1(), file.getFileName(), localAddress));
                } else {
                    XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURL(file.getSHA1(), file.getFileName()));
                }
                this.utf8Writer.write("</magnet-url>");
                this.utf8Writer.write("<name2res-url>");
                XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildFullName2ResourceURL(localAddress, urn));
                this.utf8Writer.write("</name2res-url>");
                this.utf8Writer.write("</shared-file>");
            }
            this.utf8Writer.write("</shared-file-list>");
            this.utf8Writer.write("</shared-file-export>");
        }
        catch (IOException exp) {
            NLogger.error("Sharing", (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(this.utf8Writer);
        }
    }

    static {
        $assertionsDisabled = !SharedFilesPipeFiller.class.desiredAssertionStatus();
    }
}

