/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPRequest;
import phex.msg.GUID;
import phex.msg.MsgHeader;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.net.connection.Connection;
import phex.share.FileRescanRunner;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.share.export.ExportEngine;
import phex.statistic.MessageCountStatistic;
import phex.upload.UploadManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.SearchEngine;

public class ShareManager
extends AbstractManager {
    private static final ShareFile[] EMPTY_SEARCH_RESULT = new ShareFile[0];
    private static final String INDEX_QUERY_STRING = "    ";
    private SharedFilesService sharedFilesService;

    private ShareManager() {
    }

    public static ShareManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.sharedFilesService = new SharedFilesService();
        return true;
    }

    public boolean onPostInitialization() {
        FileRescanRunner.rescan(true, false);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.getSharedFilesService().triggerSaveSharedFiles();
    }

    public SharedFilesService getSharedFilesService() {
        return this.sharedFilesService;
    }

    public ShareFile[] handleQuery(QueryMsg queryMsg) {
        List foundFiles;
        if (queryMsg.getFeatureQuerySelector() > 1) {
            return EMPTY_SEARCH_RESULT;
        }
        if (queryMsg.isRequesterFirewalled() && !NetworkManager.getInstance().hasConnectedIncoming()) {
            return EMPTY_SEARCH_RESULT;
        }
        if (UploadManager.getInstance().isHostBusy()) {
            return EMPTY_SEARCH_RESULT;
        }
        if (queryMsg.isWhatsNewQuery()) {
            return this.sharedFilesService.getNewestFiles(3);
        }
        String searchStr = queryMsg.getSearchString();
        if (searchStr.equals(INDEX_QUERY_STRING)) {
            Logger.logMessage(Logger.FINER, (short)16, "Index query detected.");
            return this.sharedFilesService.getSharedFiles();
        }
        URN[] urns = queryMsg.getQueryURNs();
        if (urns.length > 0) {
            foundFiles = this.sharedFilesService.getFilesByURNs(urns);
            if (foundFiles.size() == urns.length) {
                return this.provideResultData(foundFiles);
            }
        } else {
            foundFiles = Collections.EMPTY_LIST;
        }
        StringTokenizer tokenizer = new StringTokenizer(searchStr);
        ArrayList<String> tokenList = new ArrayList<String>(Math.min(10, tokenizer.countTokens()));
        while (tokenList.size() < 10 && tokenizer.hasMoreElements()) {
            String term = tokenizer.nextToken();
            if (term.length() < 2) continue;
            tokenList.add(term.toLowerCase());
        }
        if (tokenList.size() == 0) {
            return this.provideResultData(foundFiles);
        }
        ShareFile[] shareFiles = this.sharedFilesService.getSharedFiles();
        SearchEngine searchEngine = new SearchEngine();
        ArrayList<ShareFile> leftFiles = new ArrayList<ShareFile>(Arrays.asList(shareFiles));
        for (int i = 0; i < tokenList.size() && leftFiles.size() > 0; ++i) {
            searchEngine.setPattern((String)tokenList.get(i), true);
            for (int j = leftFiles.size() - 1; j >= 0; --j) {
                ShareFile shareFile = leftFiles.get(j);
                if (shareFile.getURN() == null) {
                    leftFiles.remove(j);
                    continue;
                }
                searchEngine.setText(shareFile.getSearchCompareTerm(), true);
                if (searchEngine.match()) continue;
                leftFiles.remove(j);
            }
        }
        if (foundFiles.size() > 0) {
            leftFiles.addAll(foundFiles);
        }
        return this.provideResultData(leftFiles);
    }

    private ShareFile[] provideResultData(List resultFileList) {
        int resultCount = resultFileList.size();
        if (resultCount == 0) {
            return EMPTY_SEARCH_RESULT;
        }
        if (resultCount > ServiceManager.sCfg.mUploadMaxSearch) {
            int toIndex = resultCount - ServiceManager.sCfg.mUploadMaxSearch;
            resultFileList.subList(0, toIndex).clear();
            resultCount = resultFileList.size();
        }
        ShareFile[] resultFiles = new ShareFile[resultCount];
        resultFiles = resultFileList.toArray(resultFiles);
        for (int i = 0; i < resultCount; ++i) {
            ShareFile shareFile = resultFiles[i];
            shareFile.incSearchCount();
        }
        return resultFiles;
    }

    public void httpRequestHandler(Connection connection, HTTPRequest httpRequest) {
        if (httpRequest.getRequestMethod().equals("GET") && httpRequest.getRequestURI().equals("/")) {
            try {
                this.sendFileListing(httpRequest, connection);
            }
            catch (IOException exp) {
                NLogger.debug(ShareManager.class, (Object)exp, (Throwable)exp);
            }
            return;
        }
        this.sendString(connection, this.buildErrorHTTP("404 Not Found", "File not found."));
    }

    private void sendString(Connection connection, String html) {
        try {
            int len;
            byte[] outbuf = new byte[html.length()];
            int lenToSend = IOUtil.serializeString(html, outbuf, 0);
            for (int lenSent = 0; lenSent < lenToSend; lenSent += len) {
                len = lenToSend - lenSent;
                if (len > 1024) {
                    len = 1024;
                }
                connection.write(outbuf, lenSent, len);
            }
            connection.flush();
            Thread.sleep(2000L);
            connection.disconnect();
        }
        catch (Exception exp) {
            NLogger.error("GLOBAL", (Object)("Exception whily trying to send sting: '" + html + "'"), (Throwable)exp);
        }
    }

    private String buildErrorHTTP(String statusStr, String errMsg) {
        StringBuffer content = new StringBuffer(300);
        content.append("<html><head><title>PHEX</title></head><body>");
        content.append(errMsg);
        content.append("<hr>Visit the Phex website at ");
        content.append("<a href=\"http://phex.sourceforge.net\">http://phex.sourceforge.net</a>.");
        content.append("</body>");
        content.append("</html>");
        StringBuffer buf = new StringBuffer(300);
        buf.append("HTTP/1.1 ").append(statusStr).append("\r\n");
        buf.append("Server: ").append(Environment.getPhexVendor()).append("\r\n");
        buf.append("Connection: close").append("\r\n");
        buf.append("Content-Type: text/plain").append("\r\n");
        buf.append("Content-Length: ").append(content.length()).append("\r\n");
        buf.append("\r\n");
        buf.append(content.toString());
        return buf.toString();
    }

    private void sendFileListing(HTTPRequest httpRequest, Connection connection) throws IOException {
        GnutellaOutputStream outStream = connection.getOutputStream();
        if (!ServiceManager.sCfg.mShareBrowseDir) {
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            String response = this.createHTTPResponse("403 Browsing disabled", headers);
            connection.write(response.getBytes());
            connection.flush();
            connection.disconnect();
            return;
        }
        HTTPHeader acceptHeader = httpRequest.getHeader("Accept");
        if (acceptHeader == null) {
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            String response = this.createHTTPResponse("406 Not Acceptable", headers);
            connection.write(response.getBytes());
            connection.flush();
            connection.disconnect();
            return;
        }
        String acceptHeaderStr = acceptHeader.getValue();
        if (acceptHeaderStr.indexOf("application/x-gnutella-packets") != -1) {
            int currentSendCount;
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            headers.addHeader(new HTTPHeader("Content-Type", "application/x-gnutella-packets"));
            headers.addHeader(new HTTPHeader("Connection", "close"));
            String response = this.createHTTPResponse("200 OK", headers);
            connection.write(response.getBytes());
            connection.flush();
            ShareFile[] shareFiles = this.sharedFilesService.getSharedFiles();
            MsgHeader header = new MsgHeader(new GUID(), -127, 2, 0, -1);
            for (int sendCount = 0; sendCount < shareFiles.length; sendCount += currentSendCount) {
                currentSendCount = Math.min(255, shareFiles.length - sendCount);
                QueryResponseRecord[] records = new QueryResponseRecord[currentSendCount];
                for (int i = 0; i < currentSendCount; ++i) {
                    QueryResponseRecord record;
                    ShareFile sfile = shareFiles[sendCount + i];
                    records[i] = record = new QueryResponseRecord(sfile.getFileIndex(), sfile.getURN(), (int)sfile.getFileSize(), sfile.getFileName(), sfile.getNetworkCreateTime(), sfile.getAltLocContainer().getAltLocForQueryResponseRecord());
                }
                DestAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
                QueryResponseMsg queryResponse = new QueryResponseMsg(header, ServiceManager.sCfg.mProgramClientID, hostAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L * 8L), records);
                queryResponse.writeMessage(outStream);
                MessageCountStatistic.queryHitMsgOutCounter.increment(1);
            }
            connection.flush();
        } else if (acceptHeaderStr.indexOf("text/html") != -1 || acceptHeaderStr.indexOf("*/*") != -1) {
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            headers.addHeader(new HTTPHeader("Content-Type", "text/html; charset=iso-8859-1"));
            headers.addHeader(new HTTPHeader("Connection", "close"));
            String response = this.createHTTPResponse("200 OK", headers);
            connection.write(response.getBytes());
            connection.flush();
            this.exportSharedFiles(outStream);
            connection.flush();
        }
        connection.disconnect();
    }

    private String createHTTPResponse(String code, HTTPHeaderGroup header) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("HTTP/1.1 ");
        buffer.append(code);
        buffer.append("\r\n");
        buffer.append(header.buildHTTPHeaderString());
        buffer.append("\r\n");
        return buffer.toString();
    }

    public void exportSharedFiles(OutputStream outStream) {
        InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/defaultSharedFilesHTMLExport.xsl");
        this.exportSharedFiles(inStream, outStream, null);
    }

    public void exportSharedFiles(InputStream styleSheetStream, OutputStream outStream, Map exportOptions) {
        ExportEngine engine = new ExportEngine();
        engine.setExportOptions(exportOptions);
        engine.startExport(styleSheetStream, outStream);
    }

    private static class Holder {
        protected static final ShareManager manager = new ShareManager();

        private Holder() {
        }
    }
}

