/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.http.Range;
import phex.net.presentation.PresentationManager;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.share.SharedResource;
import phex.thex.ShareFileThexData;
import phex.utils.NLogger;
import phex.xml.sax.share.DAlternateLocation;
import phex.xml.sax.share.DSharedFile;

public class ShareFile
extends SharedResource {
    private int fileIndex;
    private Long fileSize;
    private URN urn;
    private ShareFileThexData thexData;
    private char[] searchCompareTerm;
    private Integer searchCount;
    private Integer uploadCount;
    private AltLocContainer alternateLocations;
    private Long networkCreateTime;

    public ShareFile(File aFile) {
        super(aFile);
        this.fileSize = new Long(this.systemFile.length());
        this.searchCount = new Integer(0);
        this.uploadCount = new Integer(0);
        this.networkCreateTime = new Long(aFile.lastModified());
        SharedFilesService shareService = ShareManager.getInstance().getSharedFilesService();
        String searchCompareString = shareService.getSharedFilePath(this.systemFile);
        this.searchCompareTerm = searchCompareString.toLowerCase().toCharArray();
    }

    protected ShareFile(long aFileSize) {
        this.fileSize = new Long(aFileSize);
    }

    public URN getURN() {
        return this.urn;
    }

    public void setURN(URN urn) {
        this.urn = urn;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int index) {
        this.fileIndex = index;
    }

    public ShareFileThexData getThexData(boolean doCalculation) {
        if (this.thexData == null && this.urn != null && doCalculation && this.fileSize > 0L) {
            ShareManager.getInstance().getSharedFilesService().queueThexCalculation(this);
        }
        return this.thexData;
    }

    public void setThexData(ShareFileThexData thexData) {
        this.thexData = thexData;
    }

    public Long getNetworkCreateTime() {
        return this.networkCreateTime;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public short getRangeAvailableStatus(Range range) {
        long fileSizeVal = this.fileSize;
        long startOffset = range.getStartOffset(fileSizeVal);
        if (startOffset < 0L || startOffset >= fileSizeVal) {
            return 2;
        }
        return 0;
    }

    public AltLocContainer getAltLocContainer() {
        if (this.alternateLocations == null && this.urn != null) {
            this.alternateLocations = new AltLocContainer(this.urn);
        }
        return this.alternateLocations;
    }

    public Integer getSearchCountObject() {
        return this.searchCount;
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        this.searchCount = new Integer(this.searchCount + 1);
    }

    public Integer getUploadCountObject() {
        return this.uploadCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        this.uploadCount = new Integer(this.uploadCount + 1);
    }

    public char[] getSearchCompareTerm() {
        return this.searchCompareTerm;
    }

    public void updateFromCache(DSharedFile dFile) {
        this.searchCount = new Integer(dFile.getHitCount());
        this.uploadCount = new Integer(dFile.getUploadCount());
        this.urn = new URN("urn:sha1:" + dFile.getSha1());
        this.networkCreateTime = new Long(dFile.getCreationTime());
        String rootHash = dFile.getThexRootHash();
        if (rootHash != null) {
            String xjbLowestLevelNodes = dFile.getThexLowestLevelNodes();
            int depth = dFile.getThexTreeDepth();
            if (this.thexData == null) {
                this.thexData = new ShareFileThexData(this, rootHash, xjbLowestLevelNodes, depth);
            } else {
                this.thexData.updateFromCache(rootHash, xjbLowestLevelNodes, depth);
            }
        }
        List list = dFile.getAltLocList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                DAlternateLocation dAltLoc = (DAlternateLocation)iterator.next();
                String hostAddress = dAltLoc.getHostAddress();
                String urn = dAltLoc.getUrn();
                if (urn == null) continue;
                DestAddress address = PresentationManager.getInstance().createHostAddress(hostAddress, 6346);
                AlternateLocation altLoc = new AlternateLocation(address, new URN(urn));
                this.getAltLocContainer().addAlternateLocation(altLoc);
            }
            catch (Exception exp) {
                NLogger.error("GLOBAL", (Object)"AlternateLocation skipped due to error.", (Throwable)exp);
            }
        }
    }

    public DSharedFile createDSharedFile() {
        DSharedFile dFile = new DSharedFile();
        dFile.setFileName(this.systemFile.getAbsolutePath());
        dFile.setSha1(this.getSHA1());
        if (this.thexData != null) {
            dFile.setThexTreeDepth(this.thexData.getTreeDepth());
            dFile.setThexRootHash(this.thexData.getRootHash());
            dFile.setThexLowestLevelNodes(this.thexData.getXJBLowestLevelNodes());
        }
        dFile.setLastModified(this.systemFile.lastModified());
        dFile.setHitCount(this.searchCount);
        dFile.setUploadCount(this.uploadCount);
        dFile.setCreationTime(this.networkCreateTime);
        if (this.alternateLocations != null) {
            this.alternateLocations.createDAlternateLocationList(dFile.getAltLocList());
        }
        return dFile;
    }

    public String toString() {
        return super.toString() + " " + this.getFileName() + "  " + this.fileIndex;
    }
}

