/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import javax.xml.bind.JAXBException;
import phex.common.ExpiryDate;
import phex.security.PhexSecurityManager;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBSecurityRule;

public abstract class SecurityRule {
    protected String description;
    protected boolean isSystemRule;
    protected boolean isStrongFilter;
    protected boolean isDenyingRule;
    protected boolean isDisabled;
    protected Integer triggerCount;
    protected ExpiryDate expiryDate;
    protected boolean isDeletedOnExpiry;

    public SecurityRule(String description, boolean isDenyingRule) {
        this(description, isDenyingRule, false, false, false);
    }

    public SecurityRule(String description, boolean isDenyingRule, boolean isSystemRule, boolean isStrongFilter, boolean isDisabled) {
        this.description = description;
        this.isDenyingRule = isDenyingRule;
        this.isSystemRule = isSystemRule;
        this.isStrongFilter = isStrongFilter;
        this.isDisabled = isDisabled;
        this.expiryDate = ExpiryDate.NEVER_EXPIRY_DATE;
        this.isDeletedOnExpiry = false;
        this.triggerCount = new Integer(0);
    }

    public SecurityRule(XJBIPAccessRule xjbRule) {
        this.description = xjbRule.getDescription();
        this.isDenyingRule = xjbRule.isDenyingRule();
        this.isDisabled = xjbRule.isDisabled();
        long expiryTime = xjbRule.getExpiryDate();
        this.expiryDate = ExpiryDate.getExpiryDate(expiryTime);
        this.isDeletedOnExpiry = xjbRule.isDeletedOnExpiry();
        this.triggerCount = new Integer(xjbRule.getTriggerCount());
        this.isSystemRule = false;
        this.isStrongFilter = false;
    }

    public void setDisabled(boolean isDisabled) {
        if (this.isDisabled != isDisabled) {
            this.isDisabled = isDisabled;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setExpiryDate(ExpiryDate expiryDate) {
        if (!this.expiryDate.equals(expiryDate)) {
            this.expiryDate = expiryDate;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public ExpiryDate getExpiryDate() {
        return this.expiryDate;
    }

    public Integer getTriggerCountObject() {
        return this.triggerCount;
    }

    protected void incrementTriggerCount() {
        this.triggerCount = new Integer(this.triggerCount + 1);
        PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
    }

    public void setTriggerCount(int count) {
        this.triggerCount = new Integer(count);
    }

    public boolean isDenyingRule() {
        return this.isDenyingRule;
    }

    public void setDenyingRule(boolean isDenyingRule) {
        if (this.isDenyingRule != isDenyingRule) {
            this.isDenyingRule = isDenyingRule;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        if (!this.description.equals(aDescription)) {
            this.description = aDescription;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public void setDeleteOnExpiry(boolean isDeletedOnExpiry) {
        if (this.isDeletedOnExpiry != isDeletedOnExpiry) {
            this.isDeletedOnExpiry = isDeletedOnExpiry;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isDeletedOnExpiry() {
        return this.isDeletedOnExpiry;
    }

    public void setSystemRule(boolean isSystemRule) {
        if (this.isSystemRule != isSystemRule) {
            this.isSystemRule = isSystemRule;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isSystemRule() {
        return this.isSystemRule;
    }

    public void setStrongFilter(boolean isStrongFilter) {
        if (this.isStrongFilter != isStrongFilter) {
            this.isStrongFilter = isStrongFilter;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isStrongFilter() {
        return this.isStrongFilter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SecurityRule)) {
            return false;
        }
        SecurityRule rule = (SecurityRule)obj;
        return this.description.equals(rule.description) && rule.isSystemRule == this.isSystemRule && rule.isStrongFilter == this.isStrongFilter && rule.expiryDate.equals(this.expiryDate) && rule.isDeletedOnExpiry == this.isDeletedOnExpiry && rule.isDenyingRule == this.isDenyingRule && rule.isDisabled == this.isDisabled;
    }

    public abstract XJBSecurityRule createXJBSecurityRule() throws JAXBException;
}

