/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.util.Arrays;
import javax.xml.bind.JAXBException;
import phex.common.address.AddressUtils;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.xml.ObjectFactory;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBSecurityRule;

public class IPAccessRule
extends SecurityRule {
    public static final byte SINGLE_ADDRESS = 1;
    public static final byte NETWORK_MASK = 2;
    public static final byte NETWORK_RANGE = 3;
    private byte addressType;
    private byte[] ip;
    private byte[] compareIP;
    private String addressString;

    public IPAccessRule(String description, boolean isDenyingRule, byte type, byte[] ip, byte[] compareIP) {
        this(description, isDenyingRule, type, ip, compareIP, false, false, false);
    }

    public IPAccessRule(String description, boolean isDenyingRule, byte type, byte[] ip, byte[] compareIP, boolean isSystemRule, boolean isStrongFilter, boolean isDisabled) {
        super(description, isDenyingRule, isSystemRule, isStrongFilter, isDisabled);
        if (ip == null) {
            throw new NullPointerException("IP is null.");
        }
        this.addressType = type;
        if (type == 3 && ((ip[0] & 0xFF) > (compareIP[0] & 0xFF) || (ip[1] & 0xFF) > (compareIP[1] & 0xFF) || (ip[2] & 0xFF) > (compareIP[2] & 0xFF) || (ip[3] & 0xFF) > (compareIP[3] & 0xFF))) {
            this.ip = compareIP;
            this.compareIP = ip;
        } else {
            this.ip = ip;
            this.compareIP = compareIP;
        }
    }

    public IPAccessRule(XJBIPAccessRule xjbRule) {
        super(xjbRule);
        this.addressType = xjbRule.getAddressType();
        this.ip = xjbRule.getIp();
        this.compareIP = xjbRule.getCompareIP();
    }

    public boolean isHostIPAllowed(byte[] hostIP) {
        boolean isMatched;
        switch (this.addressType) {
            case 1: {
                isMatched = Arrays.equals(hostIP, this.ip);
                break;
            }
            case 2: {
                isMatched = (this.ip[0] & this.compareIP[0]) == (hostIP[0] & this.compareIP[0]) && (this.ip[1] & this.compareIP[1]) == (hostIP[1] & this.compareIP[1]) && (this.ip[2] & this.compareIP[2]) == (hostIP[2] & this.compareIP[2]) && (this.ip[3] & this.compareIP[3]) == (hostIP[3] & this.compareIP[3]);
                break;
            }
            case 3: {
                isMatched = (hostIP[0] & 0xFF) >= (this.ip[0] & 0xFF) && (hostIP[0] & 0xFF) <= (this.compareIP[0] & 0xFF) && (hostIP[1] & 0xFF) >= (this.ip[1] & 0xFF) && (hostIP[1] & 0xFF) <= (this.compareIP[1] & 0xFF) && (hostIP[2] & 0xFF) >= (this.ip[2] & 0xFF) && (hostIP[2] & 0xFF) <= (this.compareIP[2] & 0xFF) && (hostIP[3] & 0xFF) >= (this.ip[3] & 0xFF) && (hostIP[3] & 0xFF) <= (this.compareIP[3] & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + this.addressType);
            }
        }
        if (isMatched) {
            this.incrementTriggerCount();
        }
        return this.isDenyingRule ^ isMatched;
    }

    public byte[] getHostIP() {
        return this.ip;
    }

    public void setHostIP(byte[] ip) {
        if (!Arrays.equals(this.ip, ip)) {
            this.ip = ip;
            this.addressString = null;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public byte[] getCompareIP() {
        return this.compareIP;
    }

    public void setCompareIP(byte[] ip) {
        if (!Arrays.equals(this.compareIP, ip)) {
            this.compareIP = ip;
            this.addressString = null;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public byte getAddressType() {
        return this.addressType;
    }

    public void setAddressType(byte addressType) {
        if (this.addressType != addressType) {
            this.addressType = addressType;
            this.addressString = null;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public String getAddressString() {
        if (this.addressString == null) {
            switch (this.addressType) {
                case 1: {
                    this.addressString = AddressUtils.ip2string(this.ip);
                    break;
                }
                case 2: {
                    this.addressString = AddressUtils.ip2string(this.ip) + '/' + AddressUtils.ip2string(this.compareIP);
                    break;
                }
                case 3: {
                    this.addressString = AddressUtils.ip2string(this.ip) + '-' + AddressUtils.ip2string(this.compareIP);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + this.addressType);
                }
            }
        }
        return this.addressString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPAccessRule)) {
            return false;
        }
        IPAccessRule rule = (IPAccessRule)obj;
        return rule.addressType == this.addressType && Arrays.equals(rule.ip, this.ip) && Arrays.equals(rule.compareIP, this.compareIP) && super.equals(rule);
    }

    public XJBSecurityRule createXJBSecurityRule() throws JAXBException {
        ObjectFactory objFactory = new ObjectFactory();
        XJBIPAccessRule xjbRule = objFactory.createXJBIPAccessRule();
        if (!this.isSystemRule) {
            xjbRule.setDescription(this.description);
            xjbRule.setAddressType(this.addressType);
            xjbRule.setExpiryDate(this.expiryDate.getTime());
            xjbRule.setDeletedOnExpiry(this.isDeletedOnExpiry);
            xjbRule.setDenyingRule(this.isDenyingRule);
            xjbRule.setDisabled(this.isDisabled);
        } else {
            xjbRule.setSystemRule(true);
        }
        xjbRule.setIp(this.ip);
        xjbRule.setCompareIP(this.compareIP);
        xjbRule.setTriggerCount(this.triggerCount);
        return xjbRule;
    }
}

