/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DFilenameCondition;

public class FilenameCondition
implements Condition {
    private ListOrderedSet terms = new ListOrderedSet();

    public FilenameCondition() {
    }

    public FilenameCondition(FilenameCondition condition) {
        this();
        this.update(condition);
    }

    public synchronized void update(FilenameCondition condition) {
        this.terms.clear();
        this.terms.addAll((Collection)condition.terms);
    }

    public synchronized int getTermsCount() {
        return this.terms.size();
    }

    public synchronized Set getTerms() {
        return Collections.unmodifiableSet(this.terms);
    }

    public synchronized List getTermsList() {
        return this.terms.asList();
    }

    public synchronized FilenameCondition addTerm(String term) {
        term = term.toLowerCase();
        this.terms.add(term);
        return this;
    }

    public synchronized void removeTerm(String term) {
        this.terms.remove(term);
    }

    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        String filename = remoteFile.getFilename();
        filename = filename.toLowerCase();
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            String term = (String)iterator.next();
            if (filename.indexOf(term) == -1) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isComplete() {
        return this.getTermsCount() > 0;
    }

    public synchronized Object clone() {
        try {
            FilenameCondition clone = (FilenameCondition)super.clone();
            clone.terms = new ListOrderedSet();
            clone.terms.addAll((Collection)this.terms);
            return clone;
        }
        catch (CloneNotSupportedException exp) {
            throw new InternalError();
        }
    }

    public synchronized DCondition createDCondition() {
        DFilenameCondition dCond = new DFilenameCondition();
        ArrayList newList = new ArrayList(this.terms);
        dCond.setTerms(newList);
        return dCond;
    }
}

