/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DFileSizeCondition;

public class FileSizeCondition
implements Condition {
    private ListOrderedSet ranges = new ListOrderedSet();

    public FileSizeCondition() {
    }

    public FileSizeCondition(long min, long max) {
        this();
        this.addRange(min, max);
    }

    public FileSizeCondition(FileSizeCondition condition) {
        this();
        this.update(condition);
    }

    public synchronized void update(FileSizeCondition condition) {
        this.ranges.clear();
        Iterator iterator = condition.ranges.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            this.ranges.add(new Range(range.min, range.max));
        }
    }

    public synchronized int getRangesCount() {
        return this.ranges.size();
    }

    public synchronized Set getRanges() {
        return Collections.unmodifiableSet(this.ranges);
    }

    public synchronized List getRangesList() {
        return this.ranges.asList();
    }

    public synchronized FileSizeCondition addRange(long min, long max) {
        this.ranges.add(new Range(min, max));
        return this;
    }

    public synchronized FileSizeCondition addRange(Range range) {
        this.ranges.add(range);
        return this;
    }

    public synchronized void removeRange(Range range) {
        this.ranges.remove(range);
    }

    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        long fileSize = remoteFile.getFileSize();
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            if (range.min >= 0L && fileSize < range.min || range.max >= 0L && fileSize > range.max) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isComplete() {
        return this.getRangesCount() > 0;
    }

    public synchronized Object clone() {
        try {
            FileSizeCondition clone = (FileSizeCondition)super.clone();
            clone.ranges = new ListOrderedSet();
            clone.ranges.addAll((Collection)this.ranges);
            return clone;
        }
        catch (CloneNotSupportedException exp) {
            throw new InternalError();
        }
    }

    public synchronized DCondition createDCondition() {
        DFileSizeCondition dCond = new DFileSizeCondition();
        ArrayList newList = new ArrayList(this.ranges);
        dCond.setRanges(newList);
        return dCond;
    }

    public static FileSizeCondition create(DFileSizeCondition dCond) {
        FileSizeCondition cond = new FileSizeCondition();
        cond.ranges.addAll((Collection)dCond.getRanges());
        return cond;
    }

    public static class Range {
        public long min;
        public long max;

        public Range(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Range)) {
                return false;
            }
            Range range = (Range)obj;
            return range.min == this.min && range.max == this.max;
        }

        public int hashCode() {
            int val = 629 + (int)(this.min ^ this.min >> 32);
            val = val * 37 + (int)(this.max ^ this.max >> 32);
            return val;
        }
    }
}

