/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.query.QueryHitHost;

public class SearchResultHolder {
    private ArrayList queryHitList = new ArrayList();

    protected SearchResultHolder() {
    }

    public void addQueryHit(RemoteFile remoteFile) {
        this.queryHitList.add(remoteFile);
    }

    public int getQueryHitCount() {
        return this.queryHitList.size();
    }

    public RemoteFile getQueryHit(int index) {
        if (index < 0 || index >= this.queryHitList.size()) {
            return null;
        }
        return (RemoteFile)this.queryHitList.get(index);
    }

    public RemoteFile[] getQueryHits(int[] indices) {
        RemoteFile[] results = new RemoteFile[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            results[i] = (RemoteFile)this.queryHitList.get(indices[i]);
        }
        return results;
    }

    public RemoteFile findQueryHit(QueryHitHost qhh, URN urn, String fileName, long fileSize, int fileIndex) {
        GUID hostGUID = qhh.getHostGUID();
        DestAddress hostAddress = qhh.getHostAddress();
        int size = this.queryHitList.size();
        for (int i = 0; i < size; ++i) {
            DestAddress fileHostAddress;
            RemoteFile file = (RemoteFile)this.queryHitList.get(i);
            GUID fileHostGUID = file.getQueryHitHost().getHostGUID();
            if (fileHostGUID == null || hostGUID == null ? !(fileHostAddress = file.getQueryHitHost().getHostAddress()).equals(hostAddress) : !fileHostGUID.equals(hostGUID)) continue;
            if (!(urn != null && file.getURN() != null ? urn.equals(file.getURN()) : fileIndex == file.getFileIndex() && fileSize == file.getFileSize() && fileName.equals(file.getFilename()))) continue;
            return file;
        }
        return null;
    }
}

