/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.MediaType;
import phex.download.RemoteFile;

public class SearchFilter {
    private String name;
    private List filterTokens;
    private String filterString;
    private MediaType mediaType;
    private long minFileSize;
    private long maxFileSize;
    private long lastTimeUsed;

    public SearchFilter(String aName) {
        this.name = aName;
        this.filterTokens = new ArrayList();
        this.mediaType = MediaType.getMediaTypeAny();
        this.minFileSize = -1L;
        this.maxFileSize = -1L;
    }

    public SearchFilter() {
        this(null);
    }

    public void clearFilter() {
        this.filterTokens.clear();
        this.mediaType = MediaType.getMediaTypeAny();
        this.minFileSize = -1L;
        this.maxFileSize = -1L;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public List getFilterTokens() {
        return this.filterTokens;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }

    public String getName() {
        return this.name;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public void setLastTimeUsed(long lastTimeUsed) {
        this.lastTimeUsed = lastTimeUsed;
    }

    public String toString() {
        return this.name;
    }

    public void updateSearchFilter(String filterString) {
        this.setFilterString(filterString);
    }

    public void updateSearchFilter(String filterString, MediaType mediaType, long minFileSize, long maxFileSize) {
        this.setFilterString(filterString);
        this.mediaType = mediaType;
        this.minFileSize = minFileSize;
        this.maxFileSize = maxFileSize;
    }

    public void updateSearchFilter(long minFileSize, long maxFileSize) {
        this.minFileSize = minFileSize;
        this.maxFileSize = maxFileSize;
    }

    public boolean isFiltered(RemoteFile remoteFile) {
        return this.isFiltered(remoteFile.getFileSize(), remoteFile.getFilename(), remoteFile.getSpeed(), remoteFile.getQueryHitHost().getHostRating());
    }

    public boolean isFiltered(long fileSize, String fullFileName, long hostSpeed, int hostRating) {
        if (this.minFileSize > 0L && fileSize < this.minFileSize || this.maxFileSize > 0L && fileSize > this.maxFileSize) {
            return true;
        }
        if (!this.mediaType.isFilenameOf(fullFileName)) {
            return true;
        }
        return this.isFilenameFiltered(fullFileName);
    }

    private void setFilterString(String aFilterString) {
        this.filterString = aFilterString;
        StringTokenizer tokenizer = new StringTokenizer(this.filterString, " ");
        this.filterTokens.clear();
        while (tokenizer.hasMoreTokens()) {
            this.filterTokens.add(tokenizer.nextToken().toLowerCase());
        }
    }

    private boolean isFilenameFiltered(String filename) {
        if (this.filterTokens == null || this.filterTokens.size() == 0) {
            return false;
        }
        filename = filename.toLowerCase();
        Iterator iterator = this.filterTokens.iterator();
        while (iterator.hasNext()) {
            String token = (String)iterator.next();
            if (filename.indexOf(token) != -1) continue;
            return true;
        }
        return false;
    }
}

