/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.Cfg;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.query.BackgroundSearchContainer;
import phex.query.QueryManager;
import phex.query.RuleFilteredSearch;
import phex.query.Search;
import phex.rules.Rule;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.consequence.RemoveFromSearchConsequence;

public class ResearchSetting {
    private long lastResearchStartTime;
    private int noNewResultsCount;
    private int totalResearchCount;
    private String searchTerm;
    private RuleFilteredSearch ruledSearch;
    private boolean hasNewSearchResults;
    private SWDownloadFile downloadFile;
    private ResearchChangeListener researchChangeListener;

    public ResearchSetting(SWDownloadFile file) {
        this.downloadFile = file;
        this.researchChangeListener = new ResearchChangeListener();
    }

    public long getLastResearchStartTime() {
        return this.lastResearchStartTime;
    }

    public void setLastResearchStartTime(long time) {
        this.lastResearchStartTime = time;
    }

    public int getNoNewResultsCount() {
        return this.noNewResultsCount;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String term) {
        this.searchTerm = term;
    }

    public String getSHA1() {
        URN searchURN = this.downloadFile.getFileURN();
        if (searchURN == null || !searchURN.isSha1Nid()) {
            return "";
        }
        return searchURN.getNamespaceSpecificString();
    }

    public void startSearch(long searchTimeout) {
        long currentTime;
        if (this.ruledSearch != null && this.ruledSearch.isSearching()) {
            return;
        }
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH && this.downloadFile.getFileURN() == null) {
            return;
        }
        this.hasNewSearchResults = false;
        BackgroundSearchContainer backgroundSearchContainer = QueryManager.getInstance().getBackgroundSearchContainer();
        URN queryURN = null;
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH && this.downloadFile.getFileURN() != null) {
            queryURN = this.downloadFile.getFileURN();
        }
        Search search = backgroundSearchContainer.createSearch(this.searchTerm, queryURN, searchTimeout);
        Rule rule = new Rule();
        rule.addConsequence(RemoveFromSearchConsequence.INSTANCE);
        rule.addCondition(new NotCondition(new FileSizeCondition(this.downloadFile.getTotalDataSize(), this.downloadFile.getTotalDataSize())));
        this.ruledSearch = new RuleFilteredSearch(search, rule);
        this.ruledSearch.addSearchDataListener(this.researchChangeListener);
        ++this.totalResearchCount;
        this.lastResearchStartTime = currentTime = System.currentTimeMillis();
    }

    public int getTotalResearchCount() {
        return this.totalResearchCount;
    }

    public void stopSearch() {
        if (this.ruledSearch == null || !this.ruledSearch.isSearching()) {
            return;
        }
        this.ruledSearch.stopSearching();
    }

    public int getSearchHitCount() {
        return this.ruledSearch.getResultCount();
    }

    public int getSearchProgress() {
        return this.ruledSearch.getProgress();
    }

    public boolean isSearchRunning() {
        if (this.ruledSearch == null) {
            return false;
        }
        return this.ruledSearch.isSearching();
    }

    public class ResearchChangeListener
    implements SearchDataListener {
        public void searchDataChanged(final SearchDataEvent event) {
            if (event.getType() == 4) {
                if (!ResearchSetting.this.hasNewSearchResults) {
                    ResearchSetting.this.noNewResultsCount++;
                } else {
                    ResearchSetting.this.noNewResultsCount = 0;
                }
            }
            if (event.getType() != 1) {
                SwarmingManager.getInstance().fireDownloadFileChanged(ResearchSetting.this.downloadFile);
                return;
            }
            if (event.getType() == 1) {
                AsynchronousDispatcher.invokeLater(new Runnable(){

                    public void run() {
                        RemoteFile[] files = event.getSearchData();
                        for (int i = 0; i < files.length; ++i) {
                            boolean isAdded = ResearchSetting.this.downloadFile.addDownloadCandidate(files[i]);
                            if (!isAdded) continue;
                            ResearchSetting.this.hasNewSearchResults = true;
                        }
                        SwarmingManager.getInstance().fireDownloadFileChanged(ResearchSetting.this.downloadFile);
                    }
                });
            }
        }
    }
}

