/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.KeywordSearch;
import phex.query.QueryHitHost;
import phex.query.SearchFilter;

public class QueryResultMonitor {
    private ArrayList queryHitList = new ArrayList();
    private SearchFilter searchFilter;
    private ArrayList listenerList = new ArrayList(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePassiveSearchFilter(SearchFilter aSearchFilter) {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            this.searchFilter = aSearchFilter;
            if (this.searchFilter != null) {
                this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
            }
        }
    }

    public SearchFilter getPassiveSearchFilter() {
        return this.searchFilter;
    }

    public void processResponse(QueryResponseMsg msg) {
        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
        long speed = msg.getRemoteHostSpeed();
        GUID rcID = msg.getRemoteClientID();
        DestAddress address = msg.getDestAddress();
        QueryHitHost qhHost = new QueryHitHost(rcID, address, speed);
        qhHost.setQHDFlags(msg.getPushNeededFlag(), msg.getServerBusyFlag(), msg.getHasUploadedFlag(), msg.getUploadSpeedFlag());
        qhHost.setQueryResponseFields(msg);
        ArrayList newHitList = new ArrayList();
        int recordCount = msg.getRecordCount();
        for (int i = 0; i < recordCount; ++i) {
            QueryResponseRecord rec = msg.getMsgRecord(i);
            if (ServiceManager.sCfg.enableHitSnooping) {
                this.snoopDownloadCandidates(swarmingMgr, qhHost, rec);
            }
            if (this.searchFilter == null) continue;
            this.monitorPassiveSearch(qhHost, rec, newHitList);
        }
        if (newHitList.size() > 0) {
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorPassiveSearch(QueryHitHost qhHost, QueryResponseRecord rec, ArrayList newHitList) {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            int speed = qhHost.getHostSpeed();
            short hostRating = qhHost.getHostRating();
            long fileSize = rec.getFileSize();
            String filename = rec.getFilename();
            boolean isFiltered = this.searchFilter.isFiltered(fileSize, filename, speed, hostRating);
            if (isFiltered) {
                return;
            }
            URN urn = rec.getURN();
            int fileIndex = rec.getFileIndex();
            String metaData = rec.getMetaData();
            RemoteFile availableHit = this.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
            short score = KeywordSearch.calculateSearchScore(this.searchFilter.getFilterString(), filename);
            if (availableHit != null) {
                availableHit.updateQueryHitHost(qhHost);
                availableHit.setMetaData(metaData);
            } else {
                String pathInfo = rec.getPathInfo();
                RemoteFile rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, score);
                this.queryHitList.add(rfile);
                newHitList.add(rfile);
            }
            DestAddress[] alternateLocations = rec.getAlternateLocations();
            if (urn != null && alternateLocations != null) {
                for (int j = 0; j < alternateLocations.length; ++j) {
                    QueryHitHost qhh = new QueryHitHost(null, alternateLocations[j], -1L);
                    availableHit = this.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                    if (availableHit != null) {
                        availableHit.updateQueryHitHost(qhHost);
                        availableHit.setMetaData(metaData);
                        continue;
                    }
                    RemoteFile rfile = new RemoteFile(qhh, -1, filename, "", fileSize, urn, metaData, score);
                    this.queryHitList.add(rfile);
                    newHitList.add(rfile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFile findQueryHit(QueryHitHost qhh, URN urn, String fileName, long fileSize, int fileIndex) {
        GUID hostGUID = qhh.getHostGUID();
        DestAddress hostAddress = qhh.getHostAddress();
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            int size = this.queryHitList.size();
            for (int i = 0; i < size; ++i) {
                DestAddress fileHostAddress;
                RemoteFile file = (RemoteFile)this.queryHitList.get(i);
                GUID fileHostGUID = file.getQueryHitHost().getHostGUID();
                if (fileHostGUID == null || hostGUID == null ? !(fileHostAddress = file.getQueryHitHost().getHostAddress()).equals(hostAddress) : !fileHostGUID.equals(hostGUID)) continue;
                if (urn != null && file.getURN() != null) {
                    if (!urn.equals(file.getURN())) continue;
                    return file;
                }
                if (fileIndex != file.getFileIndex() || fileSize != file.getFileSize() || !fileName.equals(file.getFilename())) continue;
                return file;
            }
        }
        return null;
    }

    private QueryHitHost snoopDownloadCandidates(SwarmingManager swarmingMgr, QueryHitHost qhHost, QueryResponseRecord rec) {
        SWDownloadFile swdlf = swarmingMgr.getDownloadFile(rec.getFileSize(), rec.getURN());
        if (swdlf != null) {
            RemoteFile rFile = new RemoteFile(qhHost, rec.getFileIndex(), rec.getFilename(), rec.getPathInfo(), rec.getFileSize(), rec.getURN(), rec.getMetaData(), -1);
            swdlf.addDownloadCandidate(rFile);
        }
        return qhHost;
    }

    public void addSearchDataListener(SearchDataListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSearchDataListener(SearchDataListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent dataEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchDataEvent(dataEvent);
    }

    private void fireSearchDataEvent(final SearchDataEvent searchDataEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = QueryResultMonitor.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    if (!(listeners[i] instanceof SearchDataListener)) continue;
                    SearchDataListener listener = (SearchDataListener)listeners[i];
                    listener.searchDataChanged(searchDataEvent);
                }
            }
        });
    }
}

