/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.Manager;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.msg.QueryMsg;
import phex.query.BackgroundSearchContainer;
import phex.query.DynamicQueryEngine;
import phex.query.DynamicQueryWorker;
import phex.query.QueryHistoryMonitor;
import phex.query.SearchContainer;
import phex.rules.SearchFilterRules;
import phex.utils.NLogger;

public class QueryManager
implements Manager {
    private QueryHistoryMonitor queryMonitor;
    private SearchContainer searchContainer;
    private BackgroundSearchContainer backgroundSearchContainer;
    private SearchFilterRules searchFilterRules;
    private DynamicQueryWorker dynamicQueryWorker;

    public static QueryManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.queryMonitor = new QueryHistoryMonitor();
        this.searchContainer = new SearchContainer();
        this.backgroundSearchContainer = new BackgroundSearchContainer();
        this.searchFilterRules = new SearchFilterRules();
        this.searchFilterRules.load();
        this.dynamicQueryWorker = new DynamicQueryWorker();
        return true;
    }

    public boolean onPostInitialization() {
        this.dynamicQueryWorker.startQueryWorker();
        return true;
    }

    public void startupCompletedNotify() {
        Environment.getInstance().scheduleTimerTask(new ExpiredSearchCheckTimer(), 5000L, 5000L);
    }

    public void shutdown() {
        this.queryMonitor.shutdown();
        this.searchFilterRules.save();
    }

    public QueryHistoryMonitor getQueryHistoryMonitor() {
        return this.queryMonitor;
    }

    public SearchContainer getSearchContainer() {
        return this.searchContainer;
    }

    public BackgroundSearchContainer getBackgroundSearchContainer() {
        return this.backgroundSearchContainer;
    }

    public void removeHostQueries(Host host) {
        if (host.isUltrapeerLeafConnection()) {
            this.dynamicQueryWorker.removeDynamicQuerysForHost(host);
        }
    }

    public DynamicQueryEngine sendDynamicQuery(QueryMsg query, int desiredResults) {
        DynamicQueryEngine engine = new DynamicQueryEngine(query, desiredResults);
        this.dynamicQueryWorker.addDynamicQueryEngine(engine);
        return engine;
    }

    public DynamicQueryEngine sendMyQuery(QueryMsg queryMsg) {
        MsgManager msgMgr = MsgManager.getInstance();
        msgMgr.checkAndAddToQueryRoutingTable(queryMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (HostManager.getInstance().isUltrapeer()) {
            return this.sendDynamicQuery(queryMsg, 200);
        }
        msgMgr.forwardQueryToUltrapeers(queryMsg, null);
        return null;
    }

    public SearchFilterRules getSearchFilterRules() {
        return this.searchFilterRules;
    }

    private class ExpiredSearchCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 5000L;

        private ExpiredSearchCheckTimer() {
        }

        public void run() {
            try {
                long currentTime = System.currentTimeMillis();
                QueryManager.this.searchContainer.stopExpiredSearches(currentTime);
                QueryManager.this.backgroundSearchContainer.stopExpiredSearches(currentTime);
            }
            catch (Throwable th) {
                NLogger.error("GLOBAL", (Object)th, th);
            }
        }
    }

    private static class Holder {
        protected static final QueryManager manager = new QueryManager();

        private Holder() {
        }
    }
}

