/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.util.ArrayList;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.BrowseHostConnection;
import phex.connection.BrowseHostException;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.NLogger;

public class BrowseHostResults
extends Search {
    public static final short INITIALIZING = 0;
    public static final short CONNECTING = 1;
    public static final short FETCHING = 2;
    public static final short FINISHED = 3;
    public static final short CONNECTION_ERROR = 4;
    public static final short BROWSE_HOST_ERROR = 5;
    private short browseHostStatus;
    private DestAddress destAddress;
    private GUID hostGUID;
    static /* synthetic */ Class class$phex$query$BrowseHostResults;

    public BrowseHostResults(DestAddress hostAddress, GUID aHostGUID) {
        this.destAddress = hostAddress;
        this.hostGUID = aHostGUID;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void startSearching() {
        this.isSearching = true;
        Runnable runner = new Runnable(){

            public void run() {
                BrowseHostConnection connection = new BrowseHostConnection(BrowseHostResults.this.destAddress, BrowseHostResults.this.hostGUID, BrowseHostResults.this);
                try {
                    connection.sendBrowseHostRequest();
                    BrowseHostResults.this.browseHostStatus = (short)3;
                }
                catch (BrowseHostException exp) {
                    NLogger.warn(class$phex$query$BrowseHostResults == null ? (class$phex$query$BrowseHostResults = BrowseHostResults.class$("phex.query.BrowseHostResults")) : class$phex$query$BrowseHostResults, (Object)exp, (Throwable)exp);
                    BrowseHostResults.this.browseHostStatus = (short)5;
                    BrowseHostResults.this.stopSearching();
                }
                catch (IOException exp) {
                    NLogger.warn(class$phex$query$BrowseHostResults == null ? (class$phex$query$BrowseHostResults = BrowseHostResults.class$("phex.query.BrowseHostResults")) : class$phex$query$BrowseHostResults, (Object)exp, (Throwable)exp);
                    BrowseHostResults.this.browseHostStatus = (short)4;
                    BrowseHostResults.this.stopSearching();
                }
            }
        };
        ThreadPool.getInstance().addJob(runner, "BrowseHostConnection-" + Integer.toHexString(runner.hashCode()));
        this.fireSearchStarted();
    }

    public void setBrowseHostStatus(short status) {
        this.browseHostStatus = status;
    }

    public short getBrowseHostStatus() {
        return this.browseHostStatus;
    }

    public void stopSearching() {
        this.isSearching = false;
        this.fireSearchStoped();
    }

    public int getProgress() {
        switch (this.browseHostStatus) {
            case 0: {
                return 0;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 50;
            }
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(QueryResponseMsg msg) {
        long speed = msg.getRemoteHostSpeed();
        GUID rcID = msg.getRemoteClientID();
        DestAddress address = msg.getDestAddress();
        QueryHitHost qhHost = new QueryHitHost(rcID, address, speed);
        qhHost.setQHDFlags(msg.getPushNeededFlag(), msg.getServerBusyFlag(), msg.getHasUploadedFlag(), msg.getUploadSpeedFlag());
        qhHost.setQueryResponseFields(msg);
        int recordCount = msg.getRecordCount();
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(recordCount);
        for (int i = 0; i < recordCount; ++i) {
            QueryResponseRecord rec = msg.getMsgRecord(i);
            BrowseHostResults browseHostResults = this;
            synchronized (browseHostResults) {
                long fileSize = rec.getFileSize();
                String filename = rec.getFilename();
                URN urn = rec.getURN();
                int fileIndex = rec.getFileIndex();
                String metaData = rec.getMetaData();
                String pathInfo = rec.getPathInfo();
                RemoteFile rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, 100);
                this.searchResultHolder.addQueryHit(rfile);
                newHitList.add(rfile);
                continue;
            }
        }
        if (newHitList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(newHitList.size());
            }
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public String toString() {
        return "[BrowseHostResults:" + this.destAddress + "," + "@" + Integer.toHexString(this.hashCode()) + "]";
    }
}

