/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.SocketFacade;
import phex.net.presentation.def.DefaultSocketFacade;
import phex.security.PhexSecurityException;
import phex.security.PhexSecurityManager;
import phex.utils.NLogger;

public class OIOServer
extends Server {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (NLogger.isDebugEnabled("SERVER")) {
            NLogger.debug("SERVER", (Object)("Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort()));
        }
        try {
            while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    Socket incoming = this.serverSocket.accept();
                    DefaultSocketFacade incomingFacade = new DefaultSocketFacade(incoming);
                    this.handleIncomingSocket(incomingFacade);
                }
                catch (SocketException exp) {
                    NLogger.debug("SERVER", (Object)exp);
                }
                catch (PhexSecurityException exp) {
                    NLogger.debug("SERVER", (Object)exp);
                }
                catch (IOException exp) {
                    NLogger.error("SERVER", (Object)exp, (Throwable)exp);
                }
            }
        }
        catch (Exception exp) {
            NLogger.error("SERVER", (Object)exp, (Throwable)exp);
        }
        this.isRunning = false;
        NLogger.debug("SERVER", (Object)"Listener stopped.");
        DestAddress address = PresentationManager.getInstance().createHostAddress(new IpAddress(IpAddress.LOCAL_HOST_IP), 6346);
        NetworkManager.getInstance().updateLocalAddress(address);
        OIOServer oIOServer = this;
        synchronized (oIOServer) {
            this.notifyAll();
        }
    }

    private void handleIncomingSocket(SocketFacade clientSocket) throws IOException, PhexSecurityException {
        clientSocket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        DestAddress address = clientSocket.getRemoteAddress();
        NetworkHostsContainer netHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        IpAddress remoteIp = address.getIpAddress();
        if (!$assertionsDisabled && remoteIp == null) {
            throw new AssertionError();
        }
        if (!netHostsContainer.isConnectedToHost(address) && !remoteIp.isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        byte access = PhexSecurityManager.getInstance().controlHostAddressAccess(address);
        switch (access) {
            case 2: 
            case 3: {
                throw new PhexSecurityException("Host access denied: " + address);
            }
        }
        NLogger.debug("SERVER", (Object)("Accepted incoming connection from: " + address.getFullHostName()));
        IncomingConnectionDispatcher dispatcher = new IncomingConnectionDispatcher(clientSocket);
        ThreadPool.getInstance().addJob(dispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind() throws IOException {
        boolean error;
        if (!$assertionsDisabled && this.serverSocket != null) {
            throw new AssertionError();
        }
        int port = ServiceManager.sCfg.mListeningPort;
        this.serverSocket = new ServerSocket();
        int tries = 0;
        do {
            error = false;
            try {
                NLogger.debug("SERVER", (Object)("Binding to port " + port));
                this.serverSocket.bind(new InetSocketAddress(port));
            }
            catch (BindException exp) {
                NLogger.debug("SERVER", (Object)("Binding failed to port " + port));
                if (tries > 50) {
                    throw exp;
                }
                error = true;
                ++port;
                ++tries;
            }
        } while (error);
        IpAddress hostIP = this.resolveLocalHostIP();
        port = this.serverSocket.getLocalPort();
        DestAddress address = PresentationManager.getInstance().createHostAddress(hostIP, port);
        NetworkManager.getInstance().updateLocalAddress(address);
    }

    protected synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }

    static {
        $assertionsDisabled = !OIOServer.class.desiredAssertionStatus();
    }
}

