/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.def.DefaultSocketFacade;
import phex.security.PhexSecurityException;
import phex.security.PhexSecurityManager;
import phex.utils.NLogger;

public class NIOServer
extends Server {
    private ServerSocketChannel listeningChannel;
    private Selector selector;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (NLogger.isDebugEnabled("SERVER")) {
            NLogger.debug("SERVER", (Object)("Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort()));
        }
        try {
            while (this.selector.isOpen()) {
                this.selector.select(10000L);
                if (this.selector.isOpen()) {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selKey = iterator.next();
                        iterator.remove();
                        if (!selKey.isAcceptable()) continue;
                        ServerSocketChannel ssChannel = (ServerSocketChannel)selKey.channel();
                        try {
                            SocketChannel socketChannel = ssChannel.accept();
                            this.handleIncomingClientChannel(socketChannel);
                        }
                        catch (PhexSecurityException exp) {
                            NLogger.debug("SERVER", (Object)exp);
                        }
                        catch (IOException exp) {
                            NLogger.debug("SERVER", (Object)exp, (Throwable)exp);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exp) {
            NLogger.error("SERVER", (Object)exp, (Throwable)exp);
        }
        this.isRunning = false;
        NLogger.debug("SERVER", (Object)"Listener stopped.");
        PresentationManager presentationMgr = PresentationManager.getInstance();
        DestAddress localAddress = presentationMgr.createHostAddress(new IpAddress(IpAddress.LOCAL_HOST_IP), ServiceManager.sCfg.mListeningPort);
        NetworkManager.getInstance().updateLocalAddress(localAddress);
        NIOServer nIOServer = this;
        synchronized (nIOServer) {
            this.notifyAll();
        }
    }

    private void handleIncomingClientChannel(SocketChannel socketChannel) throws IOException, PhexSecurityException {
        socketChannel.configureBlocking(true);
        Socket clientSocket = socketChannel.socket();
        clientSocket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        IpAddress ip = new IpAddress(clientSocket.getInetAddress().getAddress());
        PresentationManager presentationMgr = PresentationManager.getInstance();
        DestAddress address = presentationMgr.createHostAddress(ip, clientSocket.getPort());
        NetworkHostsContainer netHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        if (!netHostsContainer.isConnectedToHost(address) && !address.getIpAddress().isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        byte access = PhexSecurityManager.getInstance().controlHostAddressAccess(address);
        switch (access) {
            case 2: 
            case 3: {
                throw new PhexSecurityException("Host access denied: " + clientSocket.getInetAddress().getHostAddress());
            }
        }
        NLogger.debug("SERVER", (Object)("Accepted incoming connection from: " + address.getFullHostName()));
        DefaultSocketFacade clientFacade = new DefaultSocketFacade(clientSocket);
        IncomingConnectionDispatcher dispatcher = new IncomingConnectionDispatcher(clientFacade);
        ThreadPool.getInstance().addJob(dispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind() throws IOException {
        boolean error;
        if (!$assertionsDisabled && this.listeningChannel != null) {
            throw new AssertionError();
        }
        int port = ServiceManager.sCfg.mListeningPort;
        this.listeningChannel = ServerSocketChannel.open();
        this.serverSocket = this.listeningChannel.socket();
        this.listeningChannel.configureBlocking(false);
        int tries = 0;
        do {
            error = false;
            try {
                NLogger.debug("SERVER", (Object)("Binding to port " + port));
                this.serverSocket.bind(new InetSocketAddress(port));
            }
            catch (BindException exp) {
                NLogger.debug("SERVER", (Object)("Binding failed to port " + port));
                if (tries > 10) {
                    throw exp;
                }
                error = true;
                ++port;
                ++tries;
            }
        } while (error);
        IpAddress hostIP = this.resolveLocalHostIP();
        port = this.serverSocket.getLocalPort();
        DestAddress address = PresentationManager.getInstance().createHostAddress(hostIP, port);
        NetworkManager.getInstance().updateLocalAddress(address);
        this.selector = Selector.open();
        this.listeningChannel.register(this.selector, 16);
    }

    protected void closeServer() {
        try {
            this.listeningChannel.close();
            SelectionKey key = this.listeningChannel.keyFor(this.selector);
            key.cancel();
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.listeningChannel = null;
    }

    static {
        $assertionsDisabled = !NIOServer.class.desiredAssertionStatus();
    }
}

