/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import phex.common.address.AddressUtils;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class TCPConnectBackVMsg
extends VendorMsg {
    public static final int VERSION = 1;
    private int port;

    public TCPConnectBackVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        if (version > 1) {
            throw new InvalidMessageException("Vendor Message 'TCPConnectBack' with invalid version: " + version);
        }
        if (data.length != 2) {
            throw new InvalidMessageException("Vendor Message 'TCPConnectBack' invalid data length: " + data.length);
        }
        this.port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(data, 0));
        if (!AddressUtils.isPortInRange(this.port)) {
            throw new InvalidMessageException("Invalid connect back port: " + this.port);
        }
    }

    public TCPConnectBackVMsg(int port) {
        super(VENDORID_BEAR, 7, 1, TCPConnectBackVMsg.buildDataBody(port));
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    private static byte[] buildDataBody(int port) {
        byte[] data = new byte[2];
        IOUtil.serializeShortLE((short)port, data, 0);
        return data;
    }
}

