/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class MessagesSupportedVMsg
extends VendorMsg {
    private static final int VERSION = 0;
    private static MessagesSupportedVMsg myMessagesSupportedVMsg;
    private HashSet supportedMessages = new HashSet();

    public MessagesSupportedVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        if (version > 0) {
            throw new InvalidMessageException("Vendor Message 'MessagesSupported' with invalid version: " + version);
        }
        if ((data.length - 2) % 8 != 0) {
            throw new InvalidMessageException("Vendor Message 'MessagesSupported' invalid data length: " + data.length);
        }
        ByteArrayInputStream dataStream = new ByteArrayInputStream(data, 0, data.length);
        try {
            int itemCount = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(dataStream));
            byte[] itemBytes = new byte[8];
            for (int i = 0; i < itemCount; ++i) {
                dataStream.read(itemBytes);
                SupportedMessage message = new SupportedMessage(itemBytes);
                this.supportedMessages.add(message);
            }
        }
        catch (IOException exp) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)exp, (Throwable)exp);
            throw new InvalidMessageException(exp.getMessage());
        }
    }

    private MessagesSupportedVMsg() {
        super(VENDORID_NULL, 0, 0, IOUtil.EMPTY_BYTE_ARRAY);
        this.createSupportedMsgData();
    }

    public static MessagesSupportedVMsg getMyMsgSupported() {
        if (myMessagesSupportedVMsg == null) {
            myMessagesSupportedVMsg = new MessagesSupportedVMsg();
        }
        return myMessagesSupportedVMsg;
    }

    public boolean isVendorMessageSupported(byte[] vendorId, int subSelector) {
        Iterator iterator = this.supportedMessages.iterator();
        while (iterator.hasNext()) {
            SupportedMessage msg = (SupportedMessage)iterator.next();
            if (!Arrays.equals(vendorId, msg.getVendorId()) || subSelector != msg.getSubSelector()) continue;
            return true;
        }
        return false;
    }

    public boolean isTCPConnectBackSupported() {
        return this.isVendorMessageSupported(VENDORID_BEAR, 7);
    }

    public boolean isPushProxySupported() {
        return this.isVendorMessageSupported(VENDORID_LIME, 21);
    }

    public boolean isHopsFlowSupported() {
        return this.isVendorMessageSupported(VENDORID_BEAR, 4);
    }

    private void createSupportedMsgData() {
        SupportedMessage supportedMsg = null;
        supportedMsg = new SupportedMessage(VENDORID_BEAR, 7, 1);
        this.supportedMessages.add(supportedMsg);
        supportedMsg = new SupportedMessage(VENDORID_BEAR, 4, 1);
        this.supportedMessages.add(supportedMsg);
        supportedMsg = new SupportedMessage(VENDORID_LIME, 21, 2);
        this.supportedMessages.add(supportedMsg);
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            IOUtil.serializeShortLE((short)this.supportedMessages.size(), outStream);
            Iterator iterator = this.supportedMessages.iterator();
            while (iterator.hasNext()) {
                supportedMsg = (SupportedMessage)iterator.next();
                supportedMsg.serialize(outStream);
            }
            byte[] data = outStream.toByteArray();
            this.setVenderMsgData(data);
        }
        catch (IOException exp) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)exp, (Throwable)exp);
        }
    }

    class SupportedMessage {
        private byte[] vendorId;
        private int subSelector;
        private int version;
        private int hashCode = -1;

        public SupportedMessage(byte[] itemBytes) {
            this.vendorId = new byte[4];
            System.arraycopy(itemBytes, 0, this.vendorId, 0, 4);
            this.subSelector = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(itemBytes, 4));
            this.version = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(itemBytes, 6));
        }

        public SupportedMessage(byte[] vendorId, int subSelector, int version) {
            this.vendorId = vendorId;
            this.subSelector = subSelector;
            this.version = version;
        }

        public void serialize(OutputStream outStream) throws IOException {
            outStream.write(this.vendorId);
            IOUtil.serializeShortLE((short)this.subSelector, outStream);
            IOUtil.serializeShortLE((short)this.version, outStream);
        }

        public int getSubSelector() {
            return this.subSelector;
        }

        public byte[] getVendorId() {
            return this.vendorId;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int h = 0;
                int vh = 0xFF & this.vendorId[0] | 0xFF00 & this.vendorId[1] << 8 | 0xFF0000 & this.vendorId[2] << 16 | this.vendorId[3] << 24;
                h = 31 * h + (vh ^ vh >> 32);
                h = 31 * h + (this.subSelector ^ this.subSelector >> 32);
                this.hashCode = h = 31 * h + (this.version ^ this.version >> 32);
            }
            return this.hashCode;
        }
    }
}

