/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.MsgHeader;
import phex.msg.RouteTableUpdateMsg;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;

public class QRResetTableMsg
extends RouteTableUpdateMsg {
    private static final int MESSAGE_LENGTH = 6;
    private int tableSize;
    private byte infinityByte;

    public QRResetTableMsg(int aTableSize, byte aInfinityByte) {
        super((byte)0, 6);
        this.tableSize = aTableSize;
        this.infinityByte = aInfinityByte;
    }

    public QRResetTableMsg(MsgHeader header, byte[] aBody) {
        super((byte)0, header);
        header.setDataLength(aBody.length);
        this.tableSize = IOUtil.deserializeIntLE(aBody, 1);
        this.infinityByte = aBody[5];
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public void writeMessage(GnutellaOutputStream outStream) throws IOException {
        super.writeMessage(outStream);
        byte[] tmpArray = new byte[5];
        IOUtil.serializeIntLE(this.tableSize, tmpArray, 0);
        tmpArray[4] = this.infinityByte;
        outStream.write(tmpArray);
    }
}

