/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class PingMsg
extends Message {
    private byte[] body;
    private byte[] udpScpByte = null;
    public static final byte UDP_SCP_MASK = 1;
    public static final byte UDP_SCP_LEAF = 0;
    public static final byte UDP_SCP_ULTRAPEER = 1;

    public PingMsg() {
        super(new MsgHeader(0, 0));
        this.body = IOUtil.EMPTY_BYTE_ARRAY;
    }

    public PingMsg(MsgHeader aHeader, byte[] aBody) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)0);
        this.body = aBody;
        this.getHeader().setDataLength(this.body.length);
    }

    public static PingMsg createUdpPingMsg() throws IOException {
        HostManager hostMgr = HostManager.getInstance();
        byte[] data = new byte[]{hostMgr.isUltrapeer() ? (byte)1 : 0};
        GGEPBlock scpExtension = new GGEPBlock();
        scpExtension.addExtension("SCP", data);
        byte[] body = scpExtension.getBytes();
        PingMsg udpPingMsg = new PingMsg();
        udpPingMsg.getHeader().setTTL((byte)1);
        udpPingMsg.getHeader().setDataLength(body.length);
        udpPingMsg.body = body;
        udpPingMsg.udpScpByte = data;
        NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" Created UDP Ping " + udpPingMsg.toString()));
        return udpPingMsg;
    }

    public static PingMsg createUdpPingMsg(byte[] bytesMsg, Host fromHost) throws InvalidMessageException {
        MsgHeader msgHdr = MsgHeader.createMsgHeader(bytesMsg, 0);
        return PingMsg.createUdpPingMsg(msgHdr, bytesMsg, 23, fromHost);
    }

    public static PingMsg createUdpPingMsg(MsgHeader msgHdr, byte[] data, int offset, Host fromHost) throws InvalidMessageException {
        if (!MessageProcessor.isValidUdpMsgHeader(msgHdr)) {
            NLogger.warn("UDP_INCOMING_MESSAGES", (Object)(" Could not create udp ping from given byte array. Message Verification failed " + new String(data)));
            throw new InvalidMessageException(" Could not create Msg Header while trying to create udp ping Msg. Message Verification failed ");
        }
        msgHdr.setFromHost(fromHost);
        byte[] body = MessageProcessor.createBody(msgHdr, data, offset);
        if (body == null) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp ping Msg");
        }
        PingMsg udpPing = new PingMsg(msgHdr, body);
        udpPing.parseGGEPBlocks();
        return udpPing;
    }

    public void writeMessage(GnutellaOutputStream outStream) throws IOException {
        this.getHeader().writeHeader(outStream);
        outStream.write(this.body, 0, this.body.length);
    }

    public byte[] getBytes() {
        byte[] data = new byte[23 + this.body.length];
        byte[] hdr = this.getHeader().getBytes();
        System.arraycopy(hdr, 0, data, 0, 23);
        System.arraycopy(this.body, 0, data, 23, this.body.length);
        return data;
    }

    private void parseGGEPBlocks() {
        byte[] data;
        GGEPBlock[] ggepBlocks;
        try {
            ggepBlocks = GGEPBlock.parseGGEPBlocks(this.body, 0);
        }
        catch (InvalidGGEPBlockException exp) {
            NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)exp);
            return;
        }
        if (GGEPBlock.isExtensionHeaderInBlocks(ggepBlocks, "SCP") && (data = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, "SCP")) != null) {
            this.udpScpByte = data;
        }
    }

    public byte[] getScpByte() {
        if (this.udpScpByte == null || this.udpScpByte.length < 1) {
            return null;
        }
        return this.udpScpByte;
    }

    public String toString() {
        return this.getDebugString();
    }

    public String getDebugString() {
        return "Ping[ HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }
}

