/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.Iterator;
import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.QueryRoutingTable;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.GUID;
import phex.msg.PingMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.query.QueryManager;
import phex.query.QueryResultMonitor;
import phex.upload.UploadManager;
import phex.utils.GUIDRoutingTable;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.QueryGUIDRoutingTable;

public final class MsgManager
extends AbstractManager {
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private QueryManager queryMgr;
    private QueryResultMonitor queryResultMonitor;
    private QueryRoutingTable lastSentQueryRoutingTable;
    private GUIDRoutingTable pingRoutingTable = new GUIDRoutingTable(120000L);
    private QueryGUIDRoutingTable queryRoutingTable = new QueryGUIDRoutingTable(300000L);
    private GUIDRoutingTable pushRoutingTable = new GUIDRoutingTable(420000L);

    private MsgManager() {
    }

    public static MsgManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.queryMgr = QueryManager.getInstance();
        Environment.getInstance().scheduleTimerTask(new QRPUpdateTimer(), 10000L, 10000L);
        Environment.getInstance().scheduleTimerTask(new HopsFlowTimer(), 120000L, 15000L);
        this.queryResultMonitor = new QueryResultMonitor();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public QueryResultMonitor getQueryResultMonitor() {
        return this.queryResultMonitor;
    }

    public QueryRoutingTable getLastSentQueryRoutingTable() {
        return this.lastSentQueryRoutingTable;
    }

    public synchronized boolean checkAndAddToPingRoutingTable(GUID pingGUID, Host sender) {
        boolean state = this.pingRoutingTable.checkAndAddRouting(pingGUID, sender);
        return state;
    }

    public synchronized boolean checkAndAddToQueryRoutingTable(GUID queryGUID, Host sender) {
        boolean state = this.queryRoutingTable.checkAndAddRouting(queryGUID, sender);
        return state;
    }

    public synchronized void addToPushRoutingTable(GUID clientID, Host sender) {
        this.pushRoutingTable.addRouting(clientID, sender);
    }

    public synchronized void removeHost(Host host) {
        this.queryMgr.removeHostQueries(host);
        this.pingRoutingTable.removeHost(host);
        this.queryRoutingTable.removeHost(host);
        this.pushRoutingTable.removeHost(host);
    }

    public synchronized Host getPushRouting(GUID clientID) {
        return this.pushRoutingTable.findRouting(clientID);
    }

    public synchronized Host getPingRouting(GUID pingGUID) {
        return this.pingRoutingTable.findRouting(pingGUID);
    }

    public synchronized QueryGUIDRoutingPair getQueryRouting(GUID queryGUID, int resultCount) {
        return this.queryRoutingTable.findRoutingForQuerys(queryGUID, resultCount);
    }

    public synchronized void processQueryResponse(Host remoteHost, QueryResponseMsg msg) {
        this.queryMgr.getSearchContainer().processQueryResponse(msg);
        this.queryMgr.getBackgroundSearchContainer().processQueryResponse(msg);
        this.queryResultMonitor.processResponse(msg);
    }

    public void forwardQuery(QueryMsg query, Host fromHost) {
        boolean isShieldedLeaf = this.hostMgr.isShieldedLeafNode();
        if (isShieldedLeaf && fromHost != null && fromHost.isLeafUltrapeerConnection()) {
            return;
        }
        if (fromHost.isUltrapeerLeafConnection()) {
            this.queryMgr.sendDynamicQuery(query, 50);
        } else if (!isShieldedLeaf) {
            if (query.getHeader().getTTL() > 0) {
                this.forwardQueryToUltrapeers(query, fromHost);
            }
            this.forwardQueryToLeaves(query, fromHost);
        }
        if (query.getHeader().getTTL() > 0) {
            Host[] hosts = this.hostsContainer.getPeerConnections();
            this.forwardQuery(query, fromHost, hosts);
        }
    }

    public void forwardQueryToLeaves(QueryMsg msg, Host fromHost) {
        Host[] hosts = this.hostsContainer.getLeafConnections();
        this.forwardQuery(msg, fromHost, hosts);
    }

    private void forwardQuery(QueryMsg msg, Host fromHost, Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            QueryRoutingTable qrt;
            if (hosts[i] == fromHost || (qrt = hosts[i].getLastReceivedRoutingTable()) != null && !qrt.containsQuery(msg)) continue;
            hosts[i].queueMessageToSend(msg);
        }
    }

    public void forwardQueryToUltrapeers(QueryMsg msg, Host fromHost) {
        Host[] ultrapeers = this.hostsContainer.getUltrapeerConnections();
        boolean lastHop = msg.getHeader().getTTL() == 1;
        for (int i = 0; i < ultrapeers.length; ++i) {
            QueryRoutingTable qrt;
            if (ultrapeers[i] == fromHost || lastHop && ultrapeers[i].isUPQueryRoutingSupported() && (qrt = ultrapeers[i].getLastReceivedRoutingTable()) != null && !qrt.containsQuery(msg)) continue;
            ultrapeers[i].queueMessageToSend(msg);
        }
    }

    public void forwardPing(PingMsg msg, Host fromHost) {
        Host[] hosts;
        boolean isShieldedLeaf = this.hostMgr.isShieldedLeafNode();
        if (isShieldedLeaf && fromHost != null && fromHost.isLeafUltrapeerConnection()) {
            return;
        }
        if (!isShieldedLeaf) {
            hosts = this.hostsContainer.getUltrapeerConnections();
            this.forwardPing(msg, fromHost, hosts);
            hosts = this.hostsContainer.getLeafConnections();
            this.forwardPing(msg, fromHost, hosts);
        }
        hosts = this.hostsContainer.getPeerConnections();
        this.forwardPing(msg, fromHost, hosts);
    }

    private void forwardPing(PingMsg msg, Host fromHost, Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            if (hosts[i] == fromHost) continue;
            hosts[i].queueMessageToSend(msg);
        }
    }

    public void pingHost(Host host) {
        this.pingHost(host, (byte)1);
    }

    public void pingHost(Host host, byte ttl) {
        PingMsg pingMsg = new PingMsg();
        pingMsg.getHeader().setTTL(ttl);
        this.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
            NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing Ping: " + pingMsg.getDebugString() + " - " + pingMsg.getHeader().getDebugString() + " - Host: " + host.toString()));
        }
        host.queueMessageToSend(pingMsg);
    }

    public void broadcastPingHosts(byte ttl) {
        PingMsg pingMsg = new PingMsg();
        pingMsg.getHeader().setTTL(ttl);
        this.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        Host[] hosts = this.hostsContainer.getUltrapeerConnections();
        this.forwardPing(pingMsg, Host.LOCAL_HOST, hosts);
    }

    public boolean requestTCPConnectBack() {
        DestAddress localAddress = NetworkManager.getInstance().getLocalAddress();
        TCPConnectBackVMsg tcpConnectBack = new TCPConnectBackVMsg(localAddress.getPort());
        Host[] hosts = this.hostsContainer.getUltrapeerConnections();
        int sentCount = 0;
        for (int i = 0; sentCount <= 3 && i < hosts.length; ++i) {
            if (!hosts[i].isTCPConnectBackSupported()) continue;
            hosts[i].queueMessageToSend(tcpConnectBack);
            ++sentCount;
        }
        return sentCount > 0;
    }

    public void updateLocalQueryRoutingTable() {
        this.lastSentQueryRoutingTable = QueryRoutingTable.createLocalQueryRoutingTable();
    }

    private class HopsFlowTimer
    extends TimerTask {
        private static final long TIMER_DELAY = 120000L;
        private static final long TIMER_PERIOD = 15000L;
        private boolean lastBusyState = false;

        private HopsFlowTimer() {
        }

        public void run() {
            try {
                if (!MsgManager.this.hostsContainer.isShieldedLeafNode()) {
                    return;
                }
                Host[] ultrapeers = MsgManager.this.hostsContainer.getUltrapeerConnections();
                boolean isHostBusy = UploadManager.getInstance().isHostBusy();
                int hopsFlowLimit = isHostBusy ? 0 : 5;
                HopsFlowVMsg msg = new HopsFlowVMsg(hopsFlowLimit);
                long now = System.currentTimeMillis();
                for (int i = 0; i < ultrapeers.length; ++i) {
                    if (!ultrapeers[i].isHopsFlowSupported() || isHostBusy == this.lastBusyState && !((double)ultrapeers[i].getConnectionUpTime(now) < 16500.0)) continue;
                    ultrapeers[i].queueMessageToSend(msg);
                }
                this.lastBusyState = isHostBusy;
            }
            catch (Throwable th) {
                NLogger.error("OUTGOING_MESSAGES", (Object)th, th);
            }
        }
    }

    private class QRPUpdateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private QRPUpdateTimer() {
        }

        public void run() {
            try {
                this.sendQueryRoutingTable();
            }
            catch (Throwable th) {
                NLogger.error("GLOBAL", (Object)th, th);
            }
        }

        private void sendQueryRoutingTable() {
            boolean isUltrapeer = MsgManager.this.hostMgr.isUltrapeer();
            if (!MsgManager.this.hostMgr.isShieldedLeafNode() && !isUltrapeer) {
                return;
            }
            Host[] hosts = MsgManager.this.hostsContainer.getUltrapeerConnections();
            QueryRoutingTable currentTable = null;
            for (int i = 0; i < hosts.length; ++i) {
                if ((!isUltrapeer ? !hosts[i].isQueryRoutingSupported() : !hosts[i].isUPQueryRoutingSupported()) || !hosts[i].isQRTableUpdateRequired()) continue;
                Logger.logMessage(Logger.FINER, (short)16, "Updating QRTable for: " + hosts[i]);
                if (currentTable == null) {
                    MsgManager.this.updateLocalQueryRoutingTable();
                    currentTable = MsgManager.this.lastSentQueryRoutingTable;
                }
                QueryRoutingTable lastSentTable = hosts[i].getLastSentRoutingTable();
                Iterator msgIterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator(currentTable, lastSentTable);
                while (msgIterator.hasNext()) {
                    RouteTableUpdateMsg msg = (RouteTableUpdateMsg)msgIterator.next();
                    hosts[i].queueMessageToSend(msg);
                }
                hosts[i].setLastSentRoutingTable(currentTable);
            }
        }
    }

    private static class Holder {
        protected static final MsgManager manager = new MsgManager();

        private Holder() {
        }
    }
}

