/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.HashSet;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.msg.GGEPBlock;
import phex.security.PhexSecurityManager;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class GGEPExtension {
    public static DestAddress[] parseAltExtensionData(GGEPBlock[] ggepBlocks) {
        byte[] altLocData = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, "ALT");
        if (altLocData == null) {
            return null;
        }
        if (altLocData.length % 6 != 0) {
            NLogger.warn("Network", (Object)("Invalid ALT GGEPBlock length: " + HexConverter.toHexString(altLocData)));
            return null;
        }
        int count = altLocData.length / 6;
        HashSet<DefaultDestAddress> proxySet = new HashSet<DefaultDestAddress>();
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        for (int i = 0; i < count; ++i) {
            int offset = i * 6;
            byte[] ip = new byte[]{altLocData[offset], altLocData[offset + 1], altLocData[offset + 2], altLocData[offset + 3]};
            int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(altLocData, offset + 4));
            DefaultDestAddress address = new DefaultDestAddress(ip, port);
            if (!address.isValidAddress() || securityMgr.controlHostAddressAccess(address) != 1) continue;
            proxySet.add(address);
        }
        DestAddress[] pushProxyAddresses = new DestAddress[proxySet.size()];
        proxySet.toArray(pushProxyAddresses);
        return pushProxyAddresses;
    }

    public static DestAddress[] parsePushProxyExtensionData(GGEPBlock[] ggepBlocks) {
        byte[] data = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, "PUSH");
        if (data == null) {
            return null;
        }
        if (data.length % 6 != 0) {
            NLogger.warn("Network", (Object)("Invalid PushProxy GGEPBlock length: " + HexConverter.toHexString(data)));
            return null;
        }
        int count = data.length / 6;
        HashSet<DefaultDestAddress> proxySet = new HashSet<DefaultDestAddress>();
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        for (int i = 0; i < count; ++i) {
            int offset = i * 6;
            byte[] ip = new byte[]{data[offset], data[offset + 1], data[offset + 2], data[offset + 3]};
            int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(data, offset + 4));
            DefaultDestAddress address = new DefaultDestAddress(ip, port);
            if (!address.isValidAddress() || securityMgr.controlHostAddressAccess(address) != 1) continue;
            proxySet.add(address);
        }
        DestAddress[] pushProxyAddresses = new DestAddress[proxySet.size()];
        proxySet.toArray(pushProxyAddresses);
        return pushProxyAddresses;
    }

    public static int parseIntExtensionData(GGEPBlock[] ggepBlocks, String headerID, int defaultValue) {
        byte[] data = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, headerID);
        if (data == null) {
            return defaultValue;
        }
        if (data.length < 1) {
            return defaultValue;
        }
        if (data.length > 4) {
            return defaultValue;
        }
        return IOUtil.deserializeIntLE(data, 0, data.length);
    }
}

