/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.statistic.StatisticsManager;
import phex.statistic.UptimeStatisticProvider;
import phex.utils.NLogger;

public class UltrapeerCapabilityChecker
extends TimerTask {
    private static final long TIMER_PERIOD = 10000L;
    private static final long TWENTY_MINUTES = 1200000L;
    private static final long TEN_MINUTES = 600000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long TWO_HOURS = 0x6DDD00L;
    private boolean isUltrapeerCapable;
    private boolean isUltrapeerOS;
    private UptimeStatisticProvider uptimeProvider;

    public UltrapeerCapabilityChecker() {
        Environment env = Environment.getInstance();
        this.isUltrapeerOS = env.isUltrapeerOS();
        this.uptimeProvider = (UptimeStatisticProvider)StatisticsManager.getInstance().getStatisticProvider("UptimeProvider");
        env.scheduleTimerTask(this, 0L, 10000L);
    }

    public void run() {
        try {
            this.checkIfUltrapeerCapable();
        }
        catch (Throwable th) {
            NLogger.error("GLOBAL", (Object)th, th);
        }
    }

    private void checkIfUltrapeerCapable() {
        boolean isCapable;
        this.isUltrapeerCapable = isCapable = ServiceManager.sCfg.allowToBecomeUP && NetworkManager.getInstance().hasConnectedIncoming() && this.isUltrapeerOS && ServiceManager.sCfg.networkSpeedKbps > 64 && ServiceManager.sCfg.mNetMaxRate > 10240 && ServiceManager.sCfg.maxTotalBandwidth > 14336 && (((LongObj)this.uptimeProvider.getValue()).getValue() > 1200000L || ((LongObj)this.uptimeProvider.getAverageValue()).getValue() > 600000L);
    }

    public boolean isUltrapeerCapable() {
        return this.isUltrapeerCapable;
    }
}

