/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.connection.ConnectionClosedException;
import phex.connection.MessageQueue;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.Message;
import phex.msg.QueryMsg;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.net.connection.Connection;
import phex.statistic.MessageCountStatistic;
import phex.utils.GnutellaInputStream;
import phex.utils.GnutellaOutputStream;
import phex.utils.NLogger;

public class Host {
    private static final Long ZERO_LONG = new Long(0L);
    private long QUERY_ROUTING_UPDATE_TIME = 300000L;
    private static final int STABLE_CONNECTION_TIME = 75000;
    public static final int DISCONNECT_POLICY_THRESHOLD = 10000;
    public static final Short TYPE_OUTGOING = new Short(1);
    public static final Short TYPE_INCOMING = new Short(2);
    public static final Short TYPE_LOCAL = new Short(3);
    public static final byte CONNECTION_NORMAL = 0;
    public static final byte CONNECTION_LEAF_UP = 1;
    public static final byte CONNECTION_UP_UP = 2;
    public static final byte CONNECTION_UP_LEAF = 3;
    private NetworkHostsContainer hostsContainer = HostManager.getInstance().getNetworkHostsContainer();
    private DestAddress hostAddress;
    private Connection connection = null;
    private int status = 0;
    private String lastStatusMsg = "";
    private long statusTime = 0L;
    private Short type = TYPE_OUTGOING;
    private boolean mHasWorker = false;
    private int mReceivedCount = 0;
    private int mSentCount = 0;
    private int mDropCount = 0;
    private long fileCount = -1L;
    private long shareSize = -1L;
    private String vendor;
    private boolean vendorChecked = false;
    private byte maxTTL = (byte)4;
    private byte hopsFlowLimit = (byte)-1;
    private int ultrapeerDegree;
    private boolean isConnectionStable = false;
    private boolean isQueryRoutingSupported = false;
    private boolean isUPQueryRoutingSupported = false;
    private boolean isDynamicQuerySupported = false;
    private long lastQRTableSentTime;
    private QueryRoutingTable lastSentQRTable;
    private QueryRoutingTable lastReceivedQRTable;
    private byte connectionType = 0;
    private MessageQueue messageQueue;
    private boolean isVendorMessageSupported = false;
    private MessagesSupportedVMsg supportedVMsgs;
    private CapabilitiesVMsg capabilitiesVMsgs;
    private DestAddress pushProxyAddress;
    public static LocalHost LOCAL_HOST = new LocalHost();

    public Host() {
    }

    public Host(DestAddress address) {
        this();
        this.hostAddress = address;
    }

    public Host(DestAddress address, Connection connection) {
        this();
        this.hostAddress = address;
        this.connection = connection;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.mReceivedCount = 0;
        this.mSentCount = 0;
        this.mDropCount = 0;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public GnutellaInputStream getInputStream() throws IOException {
        if (this.connection == null) {
            throw new ConnectionClosedException("Connection already closed");
        }
        return this.connection.getInputStream();
    }

    public GnutellaOutputStream getOutputStream() throws IOException {
        if (this.connection == null) {
            throw new ConnectionClosedException("Connection already closed");
        }
        return this.connection.getOutputStream();
    }

    public void activateInputInflation() throws IOException {
        this.getInputStream().activateInputInflation();
    }

    public void activateOutputDeflation() throws IOException {
        this.getOutputStream().activateOutputDeflation();
    }

    public void setVendor(String aVendor) {
        this.vendor = aVendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getStatus() {
        return this.status;
    }

    public String getLastStatusMsg() {
        return this.lastStatusMsg;
    }

    public void setStatus(int status) {
        this.setStatus(status, null, System.currentTimeMillis());
    }

    public void setStatus(int status, long statusTime) {
        this.setStatus(status, null, statusTime);
    }

    public void setStatus(int status, String msg) {
        this.setStatus(status, msg, System.currentTimeMillis());
    }

    public void setStatus(int status, String msg, long statusTime) {
        if (this.status == status && this.lastStatusMsg != null && this.lastStatusMsg.equals(msg)) {
            return;
        }
        this.status = status;
        this.lastStatusMsg = msg;
        this.statusTime = statusTime;
        this.hostsContainer.fireNetworkHostChanged(this);
    }

    public void checkForStableConnection(long currentTime) {
        if (this.isConnectionStable) {
            return;
        }
        if (this.status == 4 && this.getConnectionUpTime(currentTime) > 75000L) {
            this.isConnectionStable = true;
            this.hostsContainer.fireNetworkHostChanged(this);
        }
    }

    public boolean isConnectionStable() {
        return this.isConnectionStable;
    }

    public long getConnectionUpTime(long currentTime) {
        if (this.status == 4) {
            return currentTime - this.statusTime;
        }
        return 0L;
    }

    public Long getConnectionUpTimeObject(long currentTime) {
        if (this.status == 4) {
            return new Long(currentTime - this.statusTime);
        }
        return ZERO_LONG;
    }

    public boolean isErrorStatusExpired(long currentTime) {
        return (this.status == 1 || this.status == 5) && currentTime - this.statusTime > (long)ServiceManager.sCfg.hostErrorDisplayTime;
    }

    public Short getType() {
        return this.type;
    }

    public void setType(Short aType) {
        this.type = aType;
    }

    public boolean isIncomming() {
        return this.type.equals(TYPE_INCOMING);
    }

    public void setVendorMessageSupported(boolean state) {
        this.isVendorMessageSupported = state;
    }

    public boolean isVendorMessageSupported() {
        return this.isVendorMessageSupported;
    }

    public void setCapabilitiesVMsgs(CapabilitiesVMsg capabilitiesVMsgs) {
        this.capabilitiesVMsgs = capabilitiesVMsgs;
    }

    public boolean isFeatureSearchSupported() {
        return this.capabilitiesVMsgs != null && this.capabilitiesVMsgs.isFeatureSearchSupported();
    }

    public void setSupportedVMsgs(MessagesSupportedVMsg supportedVMsgs) {
        this.supportedVMsgs = supportedVMsgs;
    }

    public boolean isTCPConnectBackSupported() {
        return this.supportedVMsgs != null && this.supportedVMsgs.isTCPConnectBackSupported();
    }

    public boolean isPushProxySupported() {
        return this.supportedVMsgs != null && this.supportedVMsgs.isPushProxySupported();
    }

    public boolean isHopsFlowSupported() {
        return this.supportedVMsgs != null && this.supportedVMsgs.isHopsFlowSupported();
    }

    public DestAddress getPushProxyAddress() {
        return this.pushProxyAddress;
    }

    public void setPushProxyAddress(DestAddress address) {
        this.pushProxyAddress = address;
    }

    public void incReceivedCount() {
        ++this.mReceivedCount;
    }

    public int getReceivedCount() {
        return this.mReceivedCount;
    }

    public void incSentCount() {
        ++this.mSentCount;
    }

    public int getSentCount() {
        return this.mSentCount;
    }

    public void incDropCount() {
        ++this.mDropCount;
    }

    public int getDropCount() {
        return this.mDropCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public long getTotalSize() {
        return this.shareSize;
    }

    public void setTotalFileSize(long shareSize) {
        this.shareSize = shareSize;
    }

    public byte getMaxTTL() {
        return this.maxTTL;
    }

    public void setMaxTTL(byte maxTTL) {
        this.maxTTL = maxTTL;
    }

    public byte getHopsFlowLimit() {
        return this.hopsFlowLimit;
    }

    public void setHopsFlowLimit(byte hopsFlowLimit) {
        this.hopsFlowLimit = hopsFlowLimit;
    }

    public int getUltrapeerDegree() {
        return this.ultrapeerDegree;
    }

    public void setUltrapeerDegree(int degree) {
        this.ultrapeerDegree = degree;
    }

    public boolean tooManyDropPackets() {
        if (this.mReceivedCount < 50 && this.getConnectionUpTime(System.currentTimeMillis()) < 60000L) {
            return false;
        }
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio;
    }

    public boolean dropPacketsInRed() {
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio * 3 / 4;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.connection != null) {
            if (this.status != 1) {
                this.setStatus(5);
            }
            this.connection.disconnect();
            this.connection = null;
        }
        if (this.messageQueue != null) {
            MessageQueue messageQueue = this.messageQueue;
            synchronized (messageQueue) {
                this.messageQueue.notify();
            }
        }
    }

    public synchronized boolean isAcquiredByWorker() {
        if (this.mHasWorker) {
            return false;
        }
        this.mHasWorker = true;
        return true;
    }

    public synchronized void releaseFromWorker() {
        this.mHasWorker = false;
    }

    public int getSendQueueLength() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getQueuedMessageCount();
    }

    public int getSendDropCount() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getDropCount();
    }

    public boolean isSendQueueTooLong() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getQueuedMessageCount() >= ServiceManager.sCfg.mNetMaxSendQueue - 1;
    }

    public boolean isSendQueueInRed() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getQueuedMessageCount() >= ServiceManager.sCfg.mNetMaxSendQueue * 3 / 4;
    }

    public boolean isNoVendorDisconnectApplying() {
        if (!ServiceManager.sCfg.mDisconnectApplyPolicy || !ServiceManager.sCfg.isNoVendorNodeDisconnected) {
            return false;
        }
        if (this.vendorChecked) {
            return false;
        }
        if (this.status != 4) {
            return false;
        }
        String normalizedVendorString = this.vendor;
        normalizedVendorString = normalizedVendorString == null ? "" : normalizedVendorString.trim();
        if (normalizedVendorString.length() == 0) {
            return true;
        }
        this.vendorChecked = true;
        return false;
    }

    public boolean isFreeloader(long currentTime) {
        if (this.isUltrapeer()) {
            return false;
        }
        long timeDelta = this.getConnectionUpTime(currentTime);
        if (timeDelta >= 10000L) {
            if (ServiceManager.sCfg.freeloaderFiles > 0 && this.fileCount < (long)ServiceManager.sCfg.freeloaderFiles) {
                return true;
            }
            if (ServiceManager.sCfg.freeloaderShareSize > 0 && this.shareSize / 1024L < (long)ServiceManager.sCfg.freeloaderShareSize) {
                return true;
            }
        }
        return false;
    }

    public boolean isLeafUltrapeerConnection() {
        return this.connectionType == 1;
    }

    public boolean isUltrapeer() {
        return this.connectionType == 1 || this.connectionType == 2;
    }

    public boolean isUltrapeerLeafConnection() {
        return this.connectionType == 3;
    }

    public void setConnectionType(byte connectionType) {
        this.connectionType = connectionType;
    }

    public String toString() {
        return "Host[" + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + "," + this.vendor + ",State=" + this.status + "]";
    }

    public void sendMessage(Message message) throws IOException {
        if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
            NLogger.debug("OUTGOING_MESSAGES", (Object)("Sending message: " + message + " - " + message.getHeader().getDebugString()));
        }
        GnutellaOutputStream outStream = this.getOutputStream();
        message.writeMessage(outStream);
        if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
            NLogger.debug("OUTGOING_MESSAGES", (Object)("Message send: " + message + " - " + message.getHeader().getDebugString()));
        }
        switch (message.getHeader().getPayload()) {
            case 0: {
                MessageCountStatistic.pingMsgOutCounter.increment(1);
                break;
            }
            case 1: {
                MessageCountStatistic.pongMsgOutCounter.increment(1);
                break;
            }
            case 64: {
                MessageCountStatistic.pushMsgOutCounter.increment(1);
                break;
            }
            case -128: {
                MessageCountStatistic.queryMsgOutCounter.increment(1);
                break;
            }
            case -127: {
                MessageCountStatistic.queryHitMsgOutCounter.increment(1);
                break;
            }
            default: {
                MessageCountStatistic.totalOutMsgCounter.increment(1);
            }
        }
    }

    public void flushOutputStream() throws IOException {
        if (this.isConnected()) {
            this.connection.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessageToSend(Message message) {
        if (this.hopsFlowLimit > -1 && message instanceof QueryMsg && message.getHeader().getHopsTaken() >= this.hopsFlowLimit) {
            return;
        }
        NLogger.debug("OUTGOING_MESSAGES", (Object)("Queuing message: " + message));
        this.initMessageQueue();
        this.incSentCount();
        MessageQueue messageQueue = this.messageQueue;
        synchronized (messageQueue) {
            this.messageQueue.addMessage(message);
            this.messageQueue.notify();
        }
    }

    private void initMessageQueue() {
        if (this.messageQueue != null) {
            return;
        }
        this.messageQueue = new MessageQueue(this);
        SendEngine engine = new SendEngine();
        ThreadPool.getInstance().addJob(engine, "SendEngine-" + Integer.toHexString(engine.hashCode()));
    }

    public boolean isQRTableUpdateRequired() {
        return System.currentTimeMillis() > this.lastQRTableSentTime + this.QUERY_ROUTING_UPDATE_TIME;
    }

    public QueryRoutingTable getLastSentRoutingTable() {
        return this.lastSentQRTable;
    }

    public void setLastSentRoutingTable(QueryRoutingTable routingTable) {
        this.lastSentQRTable = routingTable;
        this.lastQRTableSentTime = System.currentTimeMillis();
    }

    public QueryRoutingTable getLastReceivedRoutingTable() {
        return this.lastReceivedQRTable;
    }

    public void setLastReceivedRoutingTable(QueryRoutingTable routingTable) {
        this.lastReceivedQRTable = routingTable;
    }

    public boolean isQueryRoutingSupported() {
        return this.isQueryRoutingSupported;
    }

    public void setQueryRoutingSupported(boolean state) {
        this.isQueryRoutingSupported = state;
    }

    public boolean isUPQueryRoutingSupported() {
        return this.isUPQueryRoutingSupported;
    }

    public void setUPQueryRoutingSupported(boolean state) {
        this.isUPQueryRoutingSupported = state;
    }

    public boolean isDynamicQuerySupported() {
        return this.isDynamicQuerySupported;
    }

    public void setDynamicQuerySupported(boolean state) {
        this.isDynamicQuerySupported = state;
    }

    public static class LocalHost
    extends Host {
        LocalHost() {
            super(NetworkManager.getInstance().getLocalAddress());
        }

        public boolean isConnected() {
            return true;
        }

        public Short getType() {
            return TYPE_LOCAL;
        }
    }

    private class SendEngine
    implements Runnable {
        private SendEngine() {
        }

        public void run() {
            while (Host.this.isConnected()) {
                try {
                    this.waitForMessageQueueNotify();
                    Host.this.messageQueue.sendQueuedMessages();
                }
                catch (ConnectionClosedException exp) {
                    return;
                }
                catch (IOException exp) {
                    Host.this.setStatus(1, exp.getMessage());
                    Host.this.hostsContainer.disconnectHost(Host.this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForMessageQueueNotify() throws ConnectionClosedException {
            MessageQueue messageQueue = Host.this.messageQueue;
            synchronized (messageQueue) {
                while (Host.this.isConnected() && Host.this.messageQueue.getQueuedMessageCount() == 0) {
                    try {
                        Host.this.messageQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!Host.this.isConnected()) {
                throw new ConnectionClosedException("Connection already closed.");
            }
        }
    }
}

