/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.host.CaughtHost;
import phex.host.CaughtHostComparator;

public class CatchedHostCache {
    private TreeSet sortedHosts = new TreeSet(new CaughtHostComparator());
    private HashMap addressHostMapping = new HashMap();

    public synchronized CaughtHost getCaughHost(DestAddress address) {
        return (CaughtHost)this.addressHostMapping.get(address);
    }

    public synchronized void add(CaughtHost host) {
        if (this.addressHostMapping.containsKey(host.getHostAddress())) {
            return;
        }
        if (this.sortedHosts.size() < ServiceManager.sCfg.mNetMaxHostToCatch) {
            this.addressHostMapping.put(host.getHostAddress(), host);
            this.sortedHosts.add(host);
        } else {
            this.addressHostMapping.put(host.getHostAddress(), host);
            this.sortedHosts.add(host);
            this.check();
            if (this.sortedHosts.size() >= ServiceManager.sCfg.mNetMaxHostToCatch) {
                CaughtHost dropObject = (CaughtHost)this.sortedHosts.first();
                this.remove(dropObject);
            }
        }
        this.check();
    }

    public synchronized void remove(CaughtHost host) {
        CaughtHost value = (CaughtHost)this.addressHostMapping.remove(host.getHostAddress());
        if (value != null) {
            this.sortedHosts.remove(value);
        }
        this.check();
    }

    public synchronized void clear() {
        this.sortedHosts.clear();
        this.addressHostMapping.clear();
    }

    public synchronized Iterator iterator() {
        return this.sortedHosts.iterator();
    }

    private void check() {
    }
}

