/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.NetworkManager;
import phex.gwebcache.GWebCacheContainer;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.NLogger;

public class GWebCacheManager
extends AbstractManager {
    private GWebCacheContainer gWebCacheContainer;
    private boolean isThreadRequestRunning = false;

    public GWebCacheContainer getGWebCacheContainer() {
        return this.gWebCacheContainer;
    }

    public synchronized void invokeQueryMoreHostsRequest(boolean preferPhex) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryHostsRunner runner = new QueryHostsRunner(preferPhex);
        ThreadPool.getInstance().addJob(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public void invokeUpdateRemoteGWebCache(DestAddress myHostAddress, boolean preferPhex) {
        UpdateGWebCacheRunner runner = new UpdateGWebCacheRunner(myHostAddress, preferPhex);
        ThreadPool.getInstance().addJob(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public synchronized void invokeQueryMoreGWebCachesRequest(boolean preferPhex) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryGWebCachesRunner runner = new QueryGWebCachesRunner(preferPhex);
        ThreadPool.getInstance().addJob(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public static GWebCacheManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.gWebCacheContainer = new GWebCacheContainer();
        return true;
    }

    public boolean onPostInitialization() {
        Environment.getInstance().scheduleTimerTask(new QueryGWebCacheTimer(), 0L, 600000L);
        Environment.getInstance().scheduleTimerTask(new UpdateGWebCacheTimer(), 3600000L, 3600000L);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    private final class UpdateGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 3600000L;

        private UpdateGWebCacheTimer() {
        }

        public void run() {
            NetworkHostsContainer networkHostsCont = HostManager.getInstance().getNetworkHostsContainer();
            NetworkManager networkMgr = NetworkManager.getInstance();
            if (networkMgr.isConnected() || networkHostsCont.getTotalConnectionCount() > 0) {
                IpAddress localIp;
                DestAddress localAddress = null;
                if (networkMgr.hasConnectedIncoming() && (localIp = (localAddress = networkMgr.getLocalAddress()).getIpAddress()) != null && localIp.isSiteLocalIP()) {
                    localAddress = null;
                }
                GWebCacheManager.this.invokeUpdateRemoteGWebCache(localAddress, true);
            }
        }
    }

    private final class QueryGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 600000L;

        private QueryGWebCacheTimer() {
        }

        public void run() {
            try {
                NetworkHostsContainer networkHostsCont = HostManager.getInstance().getNetworkHostsContainer();
                if (NetworkManager.getInstance().isConnected() || networkHostsCont.getTotalConnectionCount() > 0) {
                    GWebCacheManager.this.invokeQueryMoreGWebCachesRequest(false);
                    GWebCacheManager.this.invokeQueryMoreHostsRequest(true);
                }
            }
            catch (Throwable th) {
                NLogger.error("GWEBCACHE", (Object)th, th);
            }
        }
    }

    private final class QueryHostsRunner
    implements Runnable {
        private boolean preferPhex;

        public QueryHostsRunner(boolean preferPhex) {
            this.preferPhex = preferPhex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GWebCacheManager.this.gWebCacheContainer.queryMoreHosts(this.preferPhex);
            }
            finally {
                GWebCacheManager.this.isThreadRequestRunning = false;
            }
        }
    }

    private final class UpdateGWebCacheRunner
    implements Runnable {
        private final DestAddress myHostAddress;
        private boolean preferPhex;

        private UpdateGWebCacheRunner(DestAddress myHostAddress, boolean preferPhex) {
            this.myHostAddress = myHostAddress;
            this.preferPhex = preferPhex;
        }

        public void run() {
            GWebCacheManager.this.gWebCacheContainer.updateRemoteGWebCache(this.myHostAddress, this.preferPhex);
        }
    }

    private final class QueryGWebCachesRunner
    implements Runnable {
        private boolean preferPhex;

        public QueryGWebCachesRunner(boolean preferPhex) {
            this.preferPhex = preferPhex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GWebCacheManager.this.gWebCacheContainer.queryMoreGWebCaches(this.preferPhex);
            }
            finally {
                GWebCacheManager.this.isThreadRequestRunning = false;
            }
        }
    }

    private static class Holder {
        protected static final GWebCacheManager manager = new GWebCacheManager();

        private Holder() {
        }
    }
}

